/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.serviceprovider;

import com.sun.management.ThreadMXBean;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.EncodedSpeculationReason;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.serviceprovider.SpeculationEncodingAdapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class GraalServices {
    private static final ClassLoader JVMCI_LOADER;
    private static final ClassLoader JVMCI_PARENT_LOADER;
    private static final AtomicLong globalTimeStamp;
    private static final Method constantPoolLookupReferencedType;
    private static final Constructor<?> implicitExceptionDispatchConstructor;

    private GraalServices() {
    }

    public static <S> Iterable<S> load(Class<S> service) {
        assert (!service.getName().startsWith("jdk.vm.ci")) : "JVMCI services must be loaded via " + Services.class.getName();
        return Services.load(service);
    }

    public static <S> S loadSingle(Class<S> service, boolean required) {
        assert (!service.getName().startsWith("jdk.vm.ci")) : "JVMCI services must be loaded via " + Services.class.getName();
        Iterable<S> providers = GraalServices.load(service);
        Object singleProvider = null;
        try {
            Iterator<S> it = providers.iterator();
            while (it.hasNext()) {
                singleProvider = it.next();
                if (!it.hasNext()) continue;
                S other = it.next();
                throw new InternalError(String.format("Multiple %s providers found: %s, %s", service.getName(), singleProvider.getClass().getName(), other.getClass().getName()));
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        if (singleProvider == null && required) {
            throw new InternalError(String.format("No provider for %s found", service.getName()));
        }
        return (S)singleProvider;
    }

    public static InputStream getClassfileAsStream(Class<?> c) throws IOException {
        String classfilePath = c.getName().replace('.', '/') + ".class";
        ClassLoader cl = c.getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(classfilePath);
        }
        return cl.getResourceAsStream(classfilePath);
    }

    public static boolean isToStringTrusted(Class<?> c) {
        ClassLoader cl = c.getClassLoader();
        return cl == null || cl == JVMCI_LOADER || cl == JVMCI_PARENT_LOADER;
    }

    static SpeculationLog.SpeculationReason createSpeculationReason(int groupId, String groupName, Object ... context) {
        SpeculationEncodingAdapter adapter = new SpeculationEncodingAdapter();
        return new EncodedSpeculationReason(groupId, groupName, adapter.flatten(context));
    }

    public static String getExecutionID() {
        try {
            if (Lazy.runtimeMXBean == null) {
                return String.valueOf(GraalServices.getGlobalTimeStamp());
            }
            String runtimeName = Lazy.runtimeMXBean.getName();
            try {
                int index = runtimeName.indexOf(64);
                if (index != -1) {
                    long pid = Long.parseLong(runtimeName.substring(0, index));
                    return Long.toString(pid);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return runtimeName;
        }
        catch (LinkageError err) {
            return String.valueOf(GraalServices.getGlobalTimeStamp());
        }
    }

    public static long getGlobalTimeStamp() {
        if (globalTimeStamp.get() == 0L) {
            globalTimeStamp.compareAndSet(0L, System.currentTimeMillis());
        }
        return globalTimeStamp.get();
    }

    public static long getThreadAllocatedBytes(long id) {
        if (Lazy.threadMXBean == null) {
            throw new UnsupportedOperationException();
        }
        return Lazy.threadMXBean.getThreadAllocatedBytes(id);
    }

    public static long getCurrentThreadAllocatedBytes() {
        return GraalServices.getThreadAllocatedBytes(Thread.currentThread().getId());
    }

    public static long getCurrentThreadCpuTime() {
        if (Lazy.threadMXBean == null) {
            throw new UnsupportedOperationException();
        }
        return Lazy.threadMXBean.getCurrentThreadCpuTime();
    }

    public static boolean isThreadAllocatedMemorySupported() {
        if (Lazy.threadMXBean == null) {
            return false;
        }
        return Lazy.threadMXBean.isThreadAllocatedMemorySupported();
    }

    public static boolean isCurrentThreadCpuTimeSupported() {
        if (Lazy.threadMXBean == null) {
            return false;
        }
        return Lazy.threadMXBean.isCurrentThreadCpuTimeSupported();
    }

    public static List<String> getInputArguments() {
        if (Lazy.runtimeMXBean == null) {
            return null;
        }
        return Lazy.runtimeMXBean.getInputArguments();
    }

    public static float fma(float a, float b, float c) {
        float result = (float)((double)a * (double)b + (double)c);
        return result;
    }

    public static double fma(double a, double b, double c) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c)) {
            return Double.NaN;
        }
        boolean infiniteA = Double.isInfinite(a);
        boolean infiniteB = Double.isInfinite(b);
        boolean infiniteC = Double.isInfinite(c);
        if (infiniteA || infiniteB || infiniteC) {
            if (infiniteA && b == 0.0 || infiniteB && a == 0.0) {
                return Double.NaN;
            }
            double product = a * b;
            if (Double.isInfinite(product) && !infiniteA && !infiniteB) {
                assert (Double.isInfinite(c));
                return c;
            }
            double result = product + c;
            assert (!Double.isFinite(result));
            return result;
        }
        BigDecimal product = new BigDecimal(a).multiply(new BigDecimal(b));
        if (c == 0.0) {
            if (a == 0.0 || b == 0.0) {
                return a * b + c;
            }
            return product.doubleValue();
        }
        return product.add(new BigDecimal(c)).doubleValue();
    }

    public static VirtualObject createVirtualObject(ResolvedJavaType type, int id, boolean isAutoBox) {
        return VirtualObject.get((ResolvedJavaType)type, (int)id, (boolean)isAutoBox);
    }

    public static int getJavaUpdateVersion() {
        String vmVersion;
        Pattern p = Pattern.compile("\\d+\\.([^-]+)-.*");
        Matcher matcher = p.matcher(vmVersion = (String)Services.getSavedProperties().get("java.vm.version"));
        if (!matcher.matches()) {
            throw new InternalError("Unexpected java.vm.version value: " + vmVersion);
        }
        return Integer.parseInt(matcher.group(1));
    }

    public static JavaType lookupReferencedType(ConstantPool constantPool, int cpi, int opcode) {
        if (constantPoolLookupReferencedType != null) {
            try {
                return (JavaType)constantPoolLookupReferencedType.invoke((Object)constantPool, cpi, opcode);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        throw new InternalError("This JVMCI version doesn't support ConstantPool.lookupReferencedType()");
    }

    public static boolean hasLookupReferencedType() {
        return constantPoolLookupReferencedType != null;
    }

    public static boolean supportsArbitraryImplicitException() {
        return implicitExceptionDispatchConstructor != null;
    }

    public static Infopoint genImplicitException(int pcOffset, int dispatchOffset, DebugInfo debugInfo) {
        if (implicitExceptionDispatchConstructor == null) {
            if (pcOffset != dispatchOffset) {
                throw new InternalError("This JVMCI version doesn't support dispatching implicit exception to an arbitrary address.");
            }
            return new Infopoint(pcOffset, debugInfo, InfopointReason.IMPLICIT_EXCEPTION);
        }
        try {
            return (Infopoint)implicitExceptionDispatchConstructor.newInstance(pcOffset, dispatchOffset, debugInfo);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new InternalError("Exception when instantiating implicit exception dispatch", e);
        }
    }

    static {
        Constructor<?> tempConstructor;
        JVMCI_LOADER = GraalServices.class.getClassLoader();
        ClassLoader classLoader = JVMCI_PARENT_LOADER = JVMCI_LOADER == null ? null : JVMCI_LOADER.getParent();
        assert (JVMCI_PARENT_LOADER == null || JVMCI_PARENT_LOADER.getParent() == null);
        globalTimeStamp = new AtomicLong();
        Method lookupReferencedType = null;
        Class<ConstantPool> constantPool = ConstantPool.class;
        try {
            lookupReferencedType = constantPool.getDeclaredMethod("lookupReferencedType", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        constantPoolLookupReferencedType = lookupReferencedType;
        try {
            Class<?> implicitExceptionDispatch = Class.forName("jdk.vm.ci.code.site.ImplicitExceptionDispatch");
            tempConstructor = implicitExceptionDispatch.getConstructor(Integer.TYPE, Integer.TYPE, DebugInfo.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            tempConstructor = null;
        }
        implicitExceptionDispatchConstructor = tempConstructor;
    }

    static class Lazy {
        static final ThreadMXBean threadMXBean;
        static final RuntimeMXBean runtimeMXBean;

        Lazy() {
        }

        static {
            RuntimeMXBean resultRuntime;
            ThreadMXBean resultThread;
            try {
                resultThread = (ThreadMXBean)ManagementFactory.getThreadMXBean();
                resultRuntime = ManagementFactory.getRuntimeMXBean();
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError | UnsupportedOperationException e) {
                resultThread = null;
                resultRuntime = null;
            }
            threadMXBean = resultThread;
            runtimeMXBean = resultRuntime;
        }
    }
}

