/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.Assumptions;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;

class TruffleCompilationResultBuilderFactory
implements CompilationResultBuilderFactory {
    private final StructuredGraph graph;
    private final List<TruffleAssumption> validAssumptions;

    TruffleCompilationResultBuilderFactory(StructuredGraph graph, List<TruffleAssumption> validAssumptions) {
        this.graph = graph;
        this.validAssumptions = validAssumptions;
    }

    @Override
    public CompilationResultBuilder createBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister) {
        return new CompilationResultBuilder(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister){

            @Override
            protected void closeCompilationResult() {
                CompilationResult result = this.compilationResult;
                result.setMethods(TruffleCompilationResultBuilderFactory.this.graph.method(), TruffleCompilationResultBuilderFactory.this.graph.getMethods());
                result.setSpeculationLog(TruffleCompilationResultBuilderFactory.this.graph.getSpeculationLog());
                result.setBytecodeSize(TruffleCompilationResultBuilderFactory.this.graph.getBytecodeSize());
                HashSet<Assumptions.Assumption> newAssumptions = new HashSet<Assumptions.Assumption>();
                for (Assumptions.Assumption assumption : TruffleCompilationResultBuilderFactory.this.graph.getAssumptions()) {
                    TruffleCompilationResultBuilderFactory.processAssumption(newAssumptions, assumption, TruffleCompilationResultBuilderFactory.this.validAssumptions);
                }
                if (result.getAssumptions() != null) {
                    for (Assumptions.Assumption assumption : result.getAssumptions()) {
                        TruffleCompilationResultBuilderFactory.processAssumption(newAssumptions, assumption, TruffleCompilationResultBuilderFactory.this.validAssumptions);
                    }
                }
                result.setAssumptions(newAssumptions.toArray(new Assumptions.Assumption[newAssumptions.size()]));
                super.closeCompilationResult();
            }
        };
    }

    static void processAssumption(Set<Assumptions.Assumption> newAssumptions, Assumptions.Assumption assumption, List<TruffleAssumption> manual) {
        if (assumption != null) {
            if (assumption instanceof TruffleAssumption) {
                TruffleAssumption assumptionValidAssumption = (TruffleAssumption)assumption;
                manual.add(assumptionValidAssumption);
            } else {
                newAssumptions.add(assumption);
            }
        }
    }
}

