/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.io.PrintStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationPrinter;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompilationRequestIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.RetryableBailoutException;
import org.graalvm.compiler.core.common.util.CompilationAlarm;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.LogStream;
import org.graalvm.compiler.debug.MemUseTrackerKey;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.common.TruffleInliningData;
import org.graalvm.compiler.truffle.compiler.ExpansionStatistics;
import org.graalvm.compiler.truffle.compiler.GraphTooBigBailoutException;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PartialEvaluatorConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerBase;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleDebugContextImpl;
import org.graalvm.compiler.truffle.compiler.TruffleTierConfiguration;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentPhase;
import org.graalvm.compiler.truffle.options.OptionValuesImpl;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;

public abstract class TruffleCompilerImpl
implements TruffleCompilerBase {
    protected TruffleCompilerConfiguration config;
    protected final GraphBuilderConfiguration builderConfig;
    protected final PartialEvaluator partialEvaluator;
    protected final TrufflePostCodeInstallationTaskFactory codeInstallationTaskFactory;
    private volatile ExpansionStatistics expansionStatistics;
    private volatile boolean expansionStatisticsInitialized;
    private volatile boolean initialized;
    public static final OptimisticOptimizations Optimizations = OptimisticOptimizations.ALL.remove(OptimisticOptimizations.Optimization.UseExceptionProbability, OptimisticOptimizations.Optimization.RemoveNeverExecutedCode, OptimisticOptimizations.Optimization.UseTypeCheckedInlining, OptimisticOptimizations.Optimization.UseTypeCheckHints);
    public static final TimerKey PartialEvaluationTime = DebugContext.timer("PartialEvaluationTime").doc("Total time spent in the Truffle tier.");
    public static final TimerKey CompilationTime = DebugContext.timer("CompilationTime");
    public static final TimerKey CodeInstallationTime = DebugContext.timer("CodeInstallation");
    public static final TimerKey EncodedGraphCacheEvictionTime = DebugContext.timer("EncodedGraphCacheEvictionTime");
    public static final MemUseTrackerKey PartialEvaluationMemUse = DebugContext.memUseTracker("TrufflePartialEvaluationMemUse");
    public static final MemUseTrackerKey CompilationMemUse = DebugContext.memUseTracker("TruffleCompilationMemUse");
    public static final MemUseTrackerKey CodeInstallationMemUse = DebugContext.memUseTracker("TruffleCodeInstallationMemUse");

    public TruffleCompilerImpl(TruffleCompilerConfiguration config) {
        this.config = config;
        this.codeInstallationTaskFactory = new TrufflePostCodeInstallationTaskFactory();
        for (Backend backend : config.backends()) {
            backend.addCodeInstallationTask(this.codeInstallationTaskFactory);
        }
        ResolvedJavaType[] skippedExceptionTypes = this.getSkippedExceptionTypes(this.config.runtime());
        GraphBuilderConfiguration baseConfig = GraphBuilderConfiguration.getDefault(new GraphBuilderConfiguration.Plugins(this.config.plugins()));
        this.builderConfig = baseConfig.withSkippedExceptionTypes(skippedExceptionTypes).withOmitAssertions((Boolean)PolyglotCompilerOptions.ExcludeAssertions.getDefaultValue()).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.ExplicitOnly).withEagerResolving(true);
        this.partialEvaluator = this.createPartialEvaluator(config);
    }

    private ResolvedJavaType[] getSkippedExceptionTypes(TruffleCompilerRuntime runtime) {
        MetaAccessProvider metaAccess = this.config.lastTier().providers().getMetaAccess();
        ResolvedJavaType[] head = metaAccess.lookupJavaTypes(new Class[]{ArithmeticException.class, IllegalArgumentException.class, IllegalStateException.class, VirtualMachineError.class, IndexOutOfBoundsException.class, ClassCastException.class, BufferUnderflowException.class, BufferOverflowException.class, ReadOnlyBufferException.class});
        ResolvedJavaType[] tail = new ResolvedJavaType[]{runtime.resolveType(metaAccess, "com.oracle.truffle.api.nodes.UnexpectedResultException"), runtime.resolveType(metaAccess, "com.oracle.truffle.api.nodes.SlowPathException")};
        ResolvedJavaType[] skippedExceptionTypes = new ResolvedJavaType[head.length + tail.length];
        System.arraycopy(head, 0, skippedExceptionTypes, 0, head.length);
        System.arraycopy(tail, 0, skippedExceptionTypes, head.length, tail.length);
        return skippedExceptionTypes;
    }

    public TruffleCompilerConfiguration getConfig() {
        return this.config;
    }

    protected abstract PartialEvaluator createPartialEvaluator(TruffleCompilerConfiguration var1);

    public abstract TruffleCompilationIdentifier createCompilationIdentifier(CompilableTruffleAST var1);

    protected abstract DebugContext createDebugContext(OptionValues var1, CompilationIdentifier var2, CompilableTruffleAST var3, PrintStream var4);

    @Override
    public final TruffleCompilation openCompilation(CompilableTruffleAST compilable) {
        TTY.Filter ttyFilter = new TTY.Filter(new LogStream(new TTYToPolyglotLoggerBridge(compilable)));
        try {
            TruffleCompilationIdentifier id = this.createCompilationIdentifier(compilable);
            return new TruffleCompilationImpl(id, ttyFilter);
        }
        catch (Throwable t) {
            if (ttyFilter != null) {
                ttyFilter.close();
            }
            throw t;
        }
    }

    @Override
    public final TruffleDebugContext openDebugContext(Map<String, Object> options, TruffleCompilation compilation) {
        DebugContext debugContext;
        OptionValues graalOptions = TruffleCompilerRuntime.getRuntime().getGraalOptions(OptionValues.class);
        if (compilation == null) {
            debugContext = new DebugContext.Builder(graalOptions).build();
        } else {
            TruffleCompilationIdentifier ident = TruffleCompilerImpl.asTruffleCompilationIdentifier(compilation);
            CompilableTruffleAST compilable = ident.getCompilable();
            org.graalvm.options.OptionValues truffleOptions = TruffleCompilerImpl.getOptionsForCompiler(options);
            if (ExpansionStatistics.isEnabled(truffleOptions)) {
                graalOptions = TruffleCompilerImpl.enableNodeSourcePositions(graalOptions);
            }
            debugContext = this.createDebugContext(graalOptions, ident, compilable, DebugContext.getDefaultLogStream());
        }
        return new TruffleDebugContextImpl(debugContext);
    }

    public static PartialEvaluatorConfiguration createPartialEvaluatorConfiguration(String name) {
        for (PartialEvaluatorConfiguration candidate : GraalServices.load(PartialEvaluatorConfiguration.class)) {
            if (!candidate.name().equals(name)) continue;
            return candidate;
        }
        throw new GraalError("Cannot find partial evaluation configuration: %s", name);
    }

    private static OptionValues enableNodeSourcePositions(OptionValues values) {
        if (GraalOptions.TrackNodeSourcePosition.getValue(values).booleanValue()) {
            return values;
        }
        return new OptionValues(values, GraalOptions.TrackNodeSourcePosition, Boolean.TRUE, new Object[0]);
    }

    private static TruffleCompilationIdentifier asTruffleCompilationIdentifier(TruffleCompilation compilation) {
        if (compilation == null) {
            return null;
        }
        if (compilation instanceof TruffleCompilationImpl) {
            return ((TruffleCompilationImpl)compilation).delegate;
        }
        if (compilation instanceof TruffleCompilationIdentifier) {
            return (TruffleCompilationIdentifier)compilation;
        }
        throw new IllegalArgumentException("The compilation must be instanceof " + TruffleCompilationIdentifier.class.getSimpleName() + ", got: " + compilation.getClass());
    }

    @Override
    public final void doCompile(TruffleDebugContext truffleDebug, TruffleCompilation compilation, Map<String, Object> optionsMap, TruffleCompilationTask task, TruffleCompilerListener inListener) {
        Objects.requireNonNull(compilation, "Compilation must be non null.");
        org.graalvm.options.OptionValues options = TruffleCompilerImpl.getOptionsForCompiler(optionsMap);
        TruffleCompilationIdentifier compilationId = TruffleCompilerImpl.asTruffleCompilationIdentifier(compilation);
        CompilableTruffleAST compilable = compilationId.getCompilable();
        boolean usingCallersDebug = truffleDebug instanceof TruffleDebugContextImpl;
        if (usingCallersDebug) {
            DebugContext callerDebug = ((TruffleDebugContextImpl)truffleDebug).debugContext;
            try (DebugContext.Scope s = TruffleCompilerImpl.maybeOpenTruffleScope(compilable, callerDebug);){
                this.actuallyCompile(options, task, inListener, compilationId, compilable, callerDebug);
            }
            catch (Throwable e) {
                TruffleCompilerImpl.notifyCompilableOfFailure(compilable, e, TruffleCompilerImpl.isSuppressedFailure(compilable, e));
            }
        } else {
            OptionValues debugContextOptionValues = TruffleCompilerRuntime.getRuntime().getGraalOptions(OptionValues.class);
            try (DebugContext graalDebug = this.createDebugContext(debugContextOptionValues, compilationId, compilable, DebugContext.getDefaultLogStream());
                 DebugContext.Scope s = TruffleCompilerImpl.maybeOpenTruffleScope(compilable, graalDebug);){
                this.actuallyCompile(options, task, inListener, compilationId, compilable, graalDebug);
            }
            catch (Throwable e) {
                TruffleCompilerImpl.notifyCompilableOfFailure(compilable, e, TruffleCompilerImpl.isSuppressedFailure(compilable, e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Map<String, Object> optionsMap, CompilableTruffleAST compilable, boolean firstInitialization) {
        if (!this.initialized) {
            TruffleCompilerImpl truffleCompilerImpl = this;
            synchronized (truffleCompilerImpl) {
                if (!this.initialized) {
                    try (TTY.Filter ttyFilter = new TTY.Filter(new LogStream(new TTYToPolyglotLoggerBridge(compilable)));){
                        org.graalvm.options.OptionValues options = TruffleCompilerImpl.getOptionsForCompiler(optionsMap);
                        this.partialEvaluator.initialize(options);
                        this.initialized = true;
                        if (!((Boolean)PolyglotCompilerOptions.FirstTierUseEconomy.getValue(options)).booleanValue()) {
                            this.config = this.config.withFirstTier(this.config.lastTier());
                        }
                    }
                }
            }
        }
    }

    private void actuallyCompile(org.graalvm.options.OptionValues options, TruffleCompilationTask task, TruffleCompilerListener listener, TruffleCompilationIdentifier compilationId, CompilableTruffleAST compilable, DebugContext graalDebug) {
        TruffleCompilationWrapper truffleCompilationWrapper = new TruffleCompilationWrapper(options, this.getDebugOutputDirectory(), this.getCompilationProblemsPerAction(), compilable, new CancellableTruffleCompilationTask(task), compilationId, listener);
        truffleCompilationWrapper.run(graalDebug);
    }

    private static DebugContext.Scope maybeOpenTruffleScope(CompilableTruffleAST compilable, DebugContext debug) throws Throwable {
        if (debug.getCurrentScopeName().endsWith(".Truffle")) {
            return null;
        }
        return debug.scope((Object)"Truffle", new TruffleDebugJavaMethod(compilable));
    }

    private static void notifyCompilableOfFailure(CompilableTruffleAST compilable, Throwable e, boolean silent) {
        Throwable error = e;
        boolean graphTooBig = false;
        if (error instanceof GraphTooBigBailoutException) {
            error = error.getCause();
            graphTooBig = true;
        }
        BailoutException bailout = error instanceof BailoutException ? (BailoutException)error : null;
        boolean permanentBailout = bailout != null ? bailout.isPermanent() : false;
        Throwable finalError = error;
        compilable.onCompilationFailed(() -> CompilableTruffleAST.serializeException(finalError), silent, bailout != null, permanentBailout, graphTooBig);
    }

    @Override
    public void shutdown() {
        ExpansionStatistics histogram;
        InstrumentPhase.Instrumentation ins;
        InstrumentPhase.InstrumentationConfiguration cfg = this.partialEvaluator.instrumentationCfg;
        if (cfg != null && (cfg.instrumentBoundaries || cfg.instrumentBranches) && (ins = this.partialEvaluator.instrumentation) != null) {
            ins.dumpAccessTable();
        }
        if ((histogram = this.expansionStatistics) != null) {
            histogram.onShutdown();
            this.expansionStatistics = null;
        }
    }

    protected abstract DiagnosticsOutputDirectory getDebugOutputDirectory();

    protected abstract Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExpansionStatistics getExpansionHistogram(org.graalvm.options.OptionValues options) {
        ExpansionStatistics local = this.expansionStatistics;
        if (local == null && !this.expansionStatisticsInitialized) {
            TruffleCompilerImpl truffleCompilerImpl = this;
            synchronized (truffleCompilerImpl) {
                local = this.expansionStatistics;
                if (local == null) {
                    this.expansionStatistics = local = ExpansionStatistics.create(options);
                    this.expansionStatisticsInitialized = true;
                }
            }
        }
        return local;
    }

    public void compileAST(org.graalvm.options.OptionValues options, DebugContext debug, CompilableTruffleAST compilable, CompilationIdentifier compilationId, CancellableTruffleCompilationTask task, TruffleCompilerListener listener) {
        CompilationPrinter printer = CompilationPrinter.begin(debug.getOptions(), compilationId, new TruffleDebugJavaMethod(compilable), -1);
        StructuredGraph graph = null;
        try (CompilationAlarm alarm = CompilationAlarm.trackCompilationPeriod(debug.getOptions());){
            PhaseSuite<HighTierContext> graphBuilderSuite = this.createGraphBuilderSuite(task.isFirstTier() ? this.config.firstTier() : this.config.lastTier());
            ExpansionStatistics statistics = this.getExpansionHistogram(options);
            SpeculationLog speculationLog = compilable.getCompilationSpeculationLog();
            if (speculationLog != null) {
                speculationLog.collectFailedSpeculations();
            }
            try (DebugCloseable a = PartialEvaluationTime.start(debug);
                 DebugCloseable c = PartialEvaluationMemUse.start(debug);){
                PartialEvaluator partialEvaluator = this.partialEvaluator;
                partialEvaluator.getClass();
                PartialEvaluator.Request request = new PartialEvaluator.Request(partialEvaluator, options, debug, compilable, this.partialEvaluator.rootForCallTarget(compilable), compilationId, speculationLog, task);
                graph = this.partialEvaluator.evaluate(request);
                if (statistics != null) {
                    statistics.afterPartialEvaluation(request.compilable, request.graph);
                }
            }
            if (task.isCancelled()) {
                return;
            }
            if (statistics != null) {
                statistics.afterTruffleTier(compilable, graph);
            }
            if (listener != null) {
                listener.onTruffleTierFinished(compilable, task.inliningData(), new GraphInfoImpl(graph));
            }
            String compilationName = compilable.toString() + (task.isFirstTier() ? "#1" : "#2");
            CompilationResult compilationResult = this.compilePEGraph(graph, compilationName, graphBuilderSuite, compilable, CompilationRequestIdentifier.asCompilationRequest(compilationId), listener, task);
            if (statistics != null) {
                statistics.afterLowTier(compilable, graph);
            }
            if (listener != null) {
                listener.onSuccess(compilable, task.inliningData(), new GraphInfoImpl(graph), new CompilationResultInfoImpl(compilationResult), task.tier());
            }
            printer.finish(compilationResult);
        }
        catch (Throwable t) {
            if (t instanceof BailoutException) {
                this.handleBailout(debug, graph, (BailoutException)t);
            }
            if (listener != null) {
                BailoutException bailout = t instanceof BailoutException ? (BailoutException)t : null;
                boolean permanentBailout = bailout != null ? bailout.isPermanent() : false;
                listener.onFailure(compilable, t.toString(), bailout != null, permanentBailout, task.tier());
            }
            throw t;
        }
    }

    protected void handleBailout(DebugContext debug, StructuredGraph graph, BailoutException bailout) {
    }

    public CompilationResult compilePEGraph(StructuredGraph graph, String name, PhaseSuite<HighTierContext> graphBuilderSuite, CompilableTruffleAST compilable, CompilationRequest compilationRequest, TruffleCompilerListener listener, TruffleCompilationTask task) {
        Throwable throwable;
        Throwable throwable2;
        DebugCloseable a;
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("TruffleFinal");){
            debug.dump(1, graph, "After TruffleTier");
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        CompilationResult result = null;
        TruffleTierConfiguration tier = task.isFirstTier() ? this.config.firstTier() : this.config.lastTier();
        try {
            a = CompilationTime.start(debug);
            throwable2 = null;
            try {
                throwable = null;
                try (DebugContext.Scope s = debug.scope("TruffleGraal.GraalCompiler", graph, tier.providers().getCodeCache());
                     DebugCloseable c2 = CompilationMemUse.start(debug);){
                    Suites selectedSuites = tier.suites();
                    LIRSuites selectedLirSuites = tier.lirSuites();
                    Providers selectedProviders = tier.providers();
                    CompilationResult compilationResult = this.createCompilationResult(name, graph.compilationId(), compilable);
                    result = GraalCompiler.compileGraph(graph, graph.method(), selectedProviders, tier.backend(), graphBuilderSuite, Optimizations, graph.getProfilingInfo(), selectedSuites, selectedLirSuites, compilationResult, CompilationResultBuilderFactory.Default, false);
                }
                catch (Throwable c2) {
                    throwable = c2;
                    throw c2;
                }
            }
            catch (Throwable s) {
                throwable2 = s;
                throw s;
            }
            finally {
                if (a != null) {
                    if (throwable2 != null) {
                        try {
                            a.close();
                        }
                        catch (Throwable s) {
                            throwable2.addSuppressed(s);
                        }
                    } else {
                        a.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        if (listener != null) {
            listener.onGraalTierFinished(compilable, new GraphInfoImpl(graph));
        }
        try {
            a = CodeInstallationTime.start(debug);
            throwable2 = null;
            try {
                throwable = null;
                try (DebugCloseable c = CodeInstallationMemUse.start(debug);){
                    InstalledCode installedCode = this.createInstalledCode(compilable);
                    assert (graph.getSpeculationLog() == result.getSpeculationLog());
                    tier.backend().createInstalledCode(debug, graph.method(), compilationRequest, result, installedCode, false);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (a != null) {
                    if (throwable2 != null) {
                        try {
                            a.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        a.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return result;
    }

    protected abstract InstalledCode createInstalledCode(CompilableTruffleAST var1);

    protected boolean soleExecutionEntryPoint(InstalledCode installedCode) {
        return true;
    }

    protected void exitHostVM(int status) {
        System.exit(status);
    }

    protected abstract CompilationResult createCompilationResult(String var1, CompilationIdentifier var2, CompilableTruffleAST var3);

    public abstract PhaseSuite<HighTierContext> createGraphBuilderSuite(TruffleTierConfiguration var1);

    @Override
    public PartialEvaluator getPartialEvaluator() {
        return this.partialEvaluator;
    }

    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        return this.config.snippetReflection().asObject(CompilableTruffleAST.class, constant);
    }

    private static boolean isSuppressedFailure(CompilableTruffleAST compilable, Throwable cause) {
        return TruffleCompilerRuntime.getRuntime().isSuppressedFailure(compilable, () -> CompilableTruffleAST.serializeException(cause));
    }

    protected CompilableTruffleAST getCompilable(CompilationResult result) {
        return null;
    }

    protected void afterCodeInstallation(CompilationResult result, InstalledCode installedCode) {
    }

    @Override
    public final SnippetReflectionProvider getSnippetReflection() {
        return this.config.snippetReflection();
    }

    public static org.graalvm.options.OptionValues getOptionsForCompiler(Map<String, Object> options) {
        EconomicMap parsedOptions = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        OptionDescriptors descriptors = PolyglotCompilerOptions.getDescriptors();
        for (Map.Entry<String, Object> e : options.entrySet()) {
            OptionDescriptor descriptor = descriptors.get(e.getKey());
            OptionKey k = descriptor != null ? descriptor.getKey() : null;
            if (k == null) continue;
            Object value = e.getValue();
            if (value.getClass() == String.class) {
                value = descriptor.getKey().getType().convert((String)e.getValue());
            }
            parsedOptions.put((Object)k, value);
        }
        return new OptionValuesImpl(descriptors, (UnmodifiableEconomicMap<OptionKey<?>, Object>)parsedOptions);
    }

    private static final class TruffleCompilationImpl
    implements TruffleCompilationIdentifier {
        final TruffleCompilationIdentifier delegate;
        private final TTY.Filter ttyFilter;

        TruffleCompilationImpl(TruffleCompilationIdentifier delegate, TTY.Filter ttyFilter) {
            this.delegate = delegate;
            this.ttyFilter = ttyFilter;
        }

        @Override
        public CompilableTruffleAST getCompilable() {
            return this.delegate.getCompilable();
        }

        @Override
        public String toString(CompilationIdentifier.Verbosity verbosity) {
            return this.delegate.toString(verbosity);
        }

        @Override
        public void close() {
            try {
                this.delegate.close();
            }
            finally {
                this.ttyFilter.close();
            }
        }
    }

    private static final class TTYToPolyglotLoggerBridge
    implements Consumer<String> {
        private final CompilableTruffleAST compilable;

        TTYToPolyglotLoggerBridge(CompilableTruffleAST compilable) {
            this.compilable = compilable;
        }

        @Override
        public void accept(String message) {
            TruffleCompilerRuntime.getRuntime().log("graal", this.compilable, message);
        }
    }

    public static final class CancellableTruffleCompilationTask
    implements TruffleCompilationTask,
    Cancellable {
        private final TruffleCompilationTask delegate;

        public CancellableTruffleCompilationTask(TruffleCompilationTask delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isLastTier() {
            return this.delegate.isLastTier();
        }

        @Override
        public TruffleInliningData inliningData() {
            return this.delegate.inliningData();
        }

        @Override
        public boolean hasNextTier() {
            return this.delegate.hasNextTier();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public TruffleCompilationTask getDelegate() {
            return this.delegate;
        }
    }

    private class TrufflePostCodeInstallationTaskFactory
    extends Backend.CodeInstallationTaskFactory {
        private TrufflePostCodeInstallationTaskFactory() {
        }

        @Override
        public Backend.CodeInstallationTask create() {
            return new TruffleCodeInstallationTask();
        }
    }

    private final class TruffleCodeInstallationTask
    extends Backend.CodeInstallationTask {
        private final List<Consumer<OptimizedAssumptionDependency>> optimizedAssumptions = new ArrayList<Consumer<OptimizedAssumptionDependency>>();

        private TruffleCodeInstallationTask() {
        }

        @Override
        public void preProcess(CompilationResult result) {
            if (result == null || result.getAssumptions() == null) {
                return;
            }
            TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
            ArrayList<Assumptions.Assumption> newAssumptions = new ArrayList<Assumptions.Assumption>();
            for (Assumptions.Assumption assumption : result.getAssumptions()) {
                if (assumption != null && assumption instanceof TruffleAssumption) {
                    TruffleAssumption truffleAssumption = (TruffleAssumption)assumption;
                    Consumer<OptimizedAssumptionDependency> dep = runtime.registerOptimizedAssumptionDependency(truffleAssumption.getAssumption());
                    if (dep == null) {
                        this.notifyAssumptions(null);
                        throw new RetryableBailoutException("Assumption invalidated while compiling code: %s", new Object[]{truffleAssumption});
                    }
                    this.optimizedAssumptions.add(dep);
                    continue;
                }
                newAssumptions.add(assumption);
            }
            result.setAssumptions(newAssumptions.toArray(new Assumptions.Assumption[newAssumptions.size()]));
        }

        @Override
        public void postProcess(CompilationResult compilationResult, final InstalledCode installedCode) {
            TruffleCompilerImpl.this.afterCodeInstallation(compilationResult, installedCode);
            if (!this.optimizedAssumptions.isEmpty()) {
                CompilableTruffleAST compilable;
                OptimizedAssumptionDependency dependency = installedCode instanceof OptimizedAssumptionDependency ? (OptimizedAssumptionDependency)installedCode : (installedCode instanceof OptimizedAssumptionDependency.Access ? ((OptimizedAssumptionDependency.Access)installedCode).getDependency() : ((compilable = TruffleCompilerImpl.this.getCompilable(compilationResult)) instanceof OptimizedAssumptionDependency ? (OptimizedAssumptionDependency)((Object)compilable) : new OptimizedAssumptionDependency(){

                    @Override
                    public void onAssumptionInvalidated(Object source, CharSequence reason) {
                        installedCode.invalidate();
                    }

                    @Override
                    public boolean isValid() {
                        return installedCode.isValid();
                    }

                    @Override
                    public boolean soleExecutionEntryPoint() {
                        return TruffleCompilerImpl.this.soleExecutionEntryPoint(installedCode);
                    }

                    public String toString() {
                        return installedCode.toString();
                    }
                }));
                this.notifyAssumptions(dependency);
            }
        }

        @Override
        public void installFailed(Throwable t) {
            this.notifyAssumptions(null);
        }

        private void notifyAssumptions(OptimizedAssumptionDependency dependency) {
            ArrayList<Throwable> errors = null;
            for (Consumer<OptimizedAssumptionDependency> entry : this.optimizedAssumptions) {
                try {
                    entry.accept(dependency);
                }
                catch (Throwable t) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(t);
                }
            }
            if (errors != null) {
                StringBuilder sb = new StringBuilder("There were errors while notifying assumptions:");
                for (Throwable e : errors) {
                    sb.append(System.lineSeparator()).append("  ").append(e);
                }
                throw new RetryableBailoutException(sb.toString());
            }
        }
    }

    private final class TruffleCompilationWrapper
    extends CompilationWrapper<Void> {
        private final CompilableTruffleAST compilable;
        private final CancellableTruffleCompilationTask task;
        private final TruffleCompilerListener listener;
        private final CompilationIdentifier compilationId;
        private final org.graalvm.options.OptionValues options;
        private boolean silent;

        private TruffleCompilationWrapper(org.graalvm.options.OptionValues options, DiagnosticsOutputDirectory outputDirectory, Map<CompilationWrapper.ExceptionAction, Integer> problemsHandledPerAction, CompilableTruffleAST optimizedCallTarget, CancellableTruffleCompilationTask task, CompilationIdentifier compilationId, TruffleCompilerListener listener) {
            super(outputDirectory, problemsHandledPerAction);
            this.options = options;
            this.compilable = optimizedCallTarget;
            this.task = task;
            this.listener = listener;
            this.compilationId = compilationId;
        }

        @Override
        public String toString() {
            return this.compilable.toString();
        }

        @Override
        protected CompilationWrapper.ExceptionAction lookupAction(OptionValues compilerOptions, Throwable cause) {
            if (!(cause instanceof BailoutException && !((BailoutException)cause).isPermanent() || !this.areTruffleCompilationExceptionsFatal(this.options) && this.options.get(PolyglotCompilerOptions.CompilationFailureAction) != PolyglotCompilerOptions.ExceptionAction.Diagnose)) {
                return CompilationWrapper.ExceptionAction.Diagnose;
            }
            return super.lookupAction(compilerOptions, cause);
        }

        @Override
        protected DebugContext createRetryDebugContext(DebugContext initialDebug, OptionValues compilerOptions, PrintStream logStream) {
            this.listener.onCompilationRetry(this.compilable, this.task);
            return TruffleCompilerImpl.this.createDebugContext(compilerOptions, this.compilationId, this.compilable, logStream);
        }

        @Override
        protected void exitHostVM(int status) {
            TruffleCompilerImpl.this.exitHostVM(status);
        }

        @Override
        protected Void handleException(Throwable t) {
            TruffleCompilerImpl.notifyCompilableOfFailure(this.compilable, t, this.silent);
            return null;
        }

        @Override
        protected Void performCompilation(DebugContext debug) {
            TruffleCompilerImpl.this.compileAST(this.options, debug, this.compilable, this.compilationId, this.task, this.listener);
            return null;
        }

        private boolean areTruffleCompilationExceptionsFatal(org.graalvm.options.OptionValues optionValues) {
            boolean compilationExceptionsAreFatal = (Boolean)optionValues.get(PolyglotCompilerOptions.CompilationExceptionsAreFatal);
            boolean performanceWarningsAreFatal = !((Set)optionValues.get(PolyglotCompilerOptions.PerformanceWarningsAreFatal)).isEmpty();
            boolean exitVM = optionValues.get(PolyglotCompilerOptions.CompilationFailureAction) == PolyglotCompilerOptions.ExceptionAction.ExitVM;
            return compilationExceptionsAreFatal || performanceWarningsAreFatal || exitVM;
        }

        @Override
        protected Void onCompilationFailure(CompilationWrapper.Failure failure) {
            this.silent = TruffleCompilerImpl.isSuppressedFailure(this.compilable, failure.cause);
            failure.handle(this.silent);
            return null;
        }
    }

    static class CompilationResultInfoImpl
    implements TruffleCompilerListener.CompilationResultInfo {
        private final CompilationResult compResult;

        CompilationResultInfoImpl(CompilationResult compResult) {
            this.compResult = compResult;
        }

        @Override
        public int getTargetCodeSize() {
            return this.compResult.getTargetCodeSize();
        }

        @Override
        public int getTotalFrameSize() {
            return this.compResult.getTotalFrameSize();
        }

        @Override
        public int getExceptionHandlersCount() {
            return this.compResult.getExceptionHandlers().size();
        }

        @Override
        public int getInfopointsCount() {
            return this.compResult.getInfopoints().size();
        }

        @Override
        public String[] getInfopoints() {
            List<Infopoint> infopoints = this.compResult.getInfopoints();
            String[] res = new String[infopoints.size()];
            int i = 0;
            for (Infopoint infopoint : infopoints) {
                res[i++] = infopoint.reason.toString();
            }
            return res;
        }

        @Override
        public int getMarksCount() {
            return this.compResult.getMarks().size();
        }

        @Override
        public int getDataPatchesCount() {
            return this.compResult.getDataPatches().size();
        }
    }

    static class GraphInfoImpl
    implements TruffleCompilerListener.GraphInfo {
        private final StructuredGraph graph;

        GraphInfoImpl(StructuredGraph graph) {
            this.graph = graph;
        }

        @Override
        public int getNodeCount() {
            return this.graph.getNodeCount();
        }

        @Override
        public String[] getNodeTypes(boolean simpleNames) {
            String[] res = new String[this.graph.getNodeCount()];
            int i = 0;
            for (Node node : this.graph.getNodes()) {
                res[i++] = simpleNames ? node.getClass().getSimpleName() : node.getClass().getName();
            }
            return res;
        }
    }
}

