/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameGetTagNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameGetTagNode> TYPE = NodeClass.create(VirtualFrameGetTagNode.class);

    public VirtualFrameGetTagNode(InvocationPlugin.Receiver frame, int frameSlotIndex) {
        super(TYPE, StampFactory.forKind(JavaKind.Byte), frame, frameSlotIndex, 0, VirtualFrameAccessType.Indexed);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualObjectNode tagVirtual;
        ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
        if (tagAlias instanceof VirtualObjectNode && this.frameSlotIndex < (tagVirtual = (VirtualObjectNode)tagAlias).entryCount()) {
            ValueNode actualTag = tool.getEntry(tagVirtual, this.frameSlotIndex);
            tool.replaceWith(actualTag);
            return;
        }
        this.insertDeoptimization(tool);
    }
}

