/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import java.util.ListIterator;
import org.graalvm.compiler.loop.phases.LoopSafepointEliminationPhase;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.LoopSafepointInsertionPhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.phases.TruffleLoopSafepointEliminationPhase;
import org.graalvm.compiler.truffle.compiler.phases.TruffleSafepointInsertionPhase;

public final class TruffleCompilerPhases {
    private TruffleCompilerPhases() {
    }

    public static void register(Providers providers, Suites suites) {
        if (suites.isImmutable()) {
            throw new IllegalStateException("Suites are already immutable.");
        }
        ListIterator<BasePhase<MidTierContext>> loopSafepointInsertion = suites.getMidTier().findPhase(LoopSafepointInsertionPhase.class);
        loopSafepointInsertion.previous();
        loopSafepointInsertion.add(new TruffleSafepointInsertionPhase(providers));
        ListIterator<BasePhase<MidTierContext>> safepointElimination = suites.getMidTier().findPhase(LoopSafepointEliminationPhase.class);
        if (safepointElimination != null) {
            safepointElimination.remove();
            safepointElimination.add(new TruffleLoopSafepointEliminationPhase(providers));
        }
    }
}

