/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.truffle.compiler.nodes.frame.NewFrameNode;

public class VerifyFrameDoesNotEscapePhase
extends Phase {
    @Override
    protected void run(StructuredGraph graph) {
        for (NewFrameNode virtualFrame : graph.getNodes(NewFrameNode.TYPE)) {
            for (MethodCallTargetNode callTarget : virtualFrame.usages().filter(MethodCallTargetNode.class)) {
                if (callTarget.invoke() == null) continue;
                String properties = callTarget.getDebugProperties().toString();
                String arguments = callTarget.arguments().toString();
                GraalGraphError exception = new GraalGraphError("Frame escapes at: %s#%s\nproperties:%s\narguments: %s", callTarget, callTarget.targetMethod(), properties, arguments);
                throw GraphUtil.approxSourceException(callTarget, exception);
            }
        }
    }
}

