/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicyProvider;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;

public final class AgnosticInliningPhase
extends BasePhase<CoreProviders> {
    private static final ArrayList<InliningPolicyProvider> POLICY_PROVIDERS;
    private final PartialEvaluator partialEvaluator;
    private final PartialEvaluator.Request request;

    public AgnosticInliningPhase(PartialEvaluator partialEvaluator, PartialEvaluator.Request request) {
        this.partialEvaluator = partialEvaluator;
        this.request = request;
    }

    private static InliningPolicyProvider chosenProvider(String name) {
        for (InliningPolicyProvider provider : POLICY_PROVIDERS) {
            if (!provider.getName().equals(name)) continue;
            return provider;
        }
        throw new IllegalStateException("No inlining policy provider with provided name: " + name);
    }

    private InliningPolicyProvider getInliningPolicyProvider(boolean firstTier) {
        String policy = (String)this.request.options.get(firstTier ? PolyglotCompilerOptions.FirstTierInliningPolicy : PolyglotCompilerOptions.InliningPolicy);
        if (Objects.equals(policy, "")) {
            return POLICY_PROVIDERS.get(firstTier ? POLICY_PROVIDERS.size() - 1 : 0);
        }
        return AgnosticInliningPhase.chosenProvider(policy);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders coreProviders) {
        InliningPolicy policy = this.getInliningPolicyProvider(this.request.isFirstTier()).get(this.request.options, coreProviders);
        CallTree tree = new CallTree(this.partialEvaluator, this.request, policy);
        tree.dumpBasic("Before Inline");
        if (this.optionsAllowInlining()) {
            policy.run(tree);
            tree.dumpBasic("After Inline");
            tree.collectTargetsToDequeue(this.request.task.inliningData());
            tree.updateTracingInfo(this.request.task.inliningData());
        }
        tree.finalizeGraph();
        tree.trace();
    }

    private boolean optionsAllowInlining() {
        return (Boolean)this.request.options.get(PolyglotCompilerOptions.Inlining);
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    static {
        Iterable<InliningPolicyProvider> services = GraalServices.load(InliningPolicyProvider.class);
        ArrayList<InliningPolicyProvider> providers = new ArrayList<InliningPolicyProvider>();
        for (InliningPolicyProvider provider : services) {
            providers.add(provider);
        }
        Collections.sort(providers);
        POLICY_PROVIDERS = providers;
    }
}

