/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.compiler.truffle.runtime.BaseOSRRootNode;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;

final class BytecodeOSRRootNode
extends BaseOSRRootNode {
    @Node.Child
    private BytecodeOSRNode bytecodeOSRNode;
    private final int target;
    private final Object interpreterState;
    @CompilerDirectives.CompilationFinal
    private boolean seenMaterializedFrame;

    BytecodeOSRRootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor, BytecodeOSRNode bytecodeOSRNode, int target, Object interpreterState) {
        super(language, frameDescriptor);
        this.bytecodeOSRNode = bytecodeOSRNode;
        this.target = target;
        this.interpreterState = interpreterState;
        this.seenMaterializedFrame = BytecodeOSRRootNode.materializeCalled(frameDescriptor);
    }

    private static boolean materializeCalled(FrameDescriptor frameDescriptor) {
        return ((GraalTruffleRuntime)Truffle.getRuntime()).getFrameMaterializeCalled(frameDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeOSR(VirtualFrame frame) {
        VirtualFrame parentFrame = (VirtualFrame)frame.getArguments()[0];
        if (!this.seenMaterializedFrame && BytecodeOSRRootNode.materializeCalled(parentFrame.getFrameDescriptor())) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenMaterializedFrame = true;
        }
        if (this.seenMaterializedFrame) {
            return this.bytecodeOSRNode.executeOSR(parentFrame, this.target, this.interpreterState);
        }
        this.bytecodeOSRNode.copyIntoOSRFrame(frame, parentFrame, this.target);
        try {
            Object object = this.bytecodeOSRNode.executeOSR(frame, this.target, this.interpreterState);
            return object;
        }
        finally {
            this.bytecodeOSRNode.restoreParentFrame(frame, parentFrame);
        }
    }

    public String toString() {
        return this.bytecodeOSRNode.toString() + "<OSR@" + this.target + ">";
    }
}

