/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.impl.DefaultCompilerOptions;

public class GraalCompilerOptions
extends DefaultCompilerOptions {
    private int minInliningMaxCallerSize = 0;

    public boolean supportsOption(String name) {
        switch (name) {
            case "MinInliningMaxCallerSize": {
                return true;
            }
        }
        return false;
    }

    public void setOption(String name, Object value) {
        switch (name) {
            case "MinInliningMaxCallerSize": {
                this.minInliningMaxCallerSize = GraalCompilerOptions.getInteger(name, value);
                break;
            }
            default: {
                super.setOption(name, value);
            }
        }
    }

    private static int getInteger(String name, Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnsupportedOperationException(String.format("Option %s expected an int value", name));
    }

    public int getMinInliningMaxCallerSize() {
        return this.minInliningMaxCallerSize;
    }
}

