/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

public abstract class GraalFastThreadLocal
extends AbstractFastThreadLocal {
    protected GraalFastThreadLocal() {
    }

    public abstract void set(Object[] var1);

    public abstract Object[] get();

    public final <C> C fastGet(int index, Class<C> castType, boolean invalidateOnNull) {
        if (CompilerDirectives.inCompiledCode()) {
            CompilerAsserts.partialEvaluationConstant((int)index);
            CompilerAsserts.partialEvaluationConstant(castType);
            Object[] array = this.get();
            if (array == null) {
                if (invalidateOnNull) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return null;
            }
            Object v = OptimizedCallTarget.castArrayFixedLength(array, index + 1)[index];
            C result = OptimizedCallTarget.unsafeCast(v, castType, true, false, true);
            return result;
        }
        Object[] data = this.get();
        if (data == null) {
            return null;
        }
        Object result = data[index];
        assert (castType == null || result == null || result.getClass() == castType) : "Invalid exact type returned";
        return (C)result;
    }
}

