/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Method;
import jdk.vm.ci.code.stack.InspectedFrame;
import org.graalvm.compiler.truffle.runtime.CompilationState;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeSupport;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

public class GraalFrameInstance
implements FrameInstance {
    static final int CALL_TARGET_INDEX = 0;
    static final int FRAME_INDEX = 1;
    static final int OPTIMIZATION_TIER_FRAME_INDEX = 2;
    static final int CALL_NODE_NOTIFY_INDEX = 1;
    static final Method CALL_TARGET_METHOD;
    static final Method CALL_DIRECT;
    static final Method CALL_INLINED;
    static final Method CALL_INLINED_CALL;
    static final Method CALL_INDIRECT;
    private final InspectedFrame callTargetFrame;
    private final InspectedFrame callNodeFrame;

    GraalFrameInstance(InspectedFrame callTargetFrame, InspectedFrame callNodeFrame) {
        this.callTargetFrame = callTargetFrame;
        this.callNodeFrame = callNodeFrame;
    }

    @CompilerDirectives.TruffleBoundary
    protected Frame getFrameFrom(InspectedFrame inspectedFrame, FrameInstance.FrameAccess access) {
        if ((access == FrameInstance.FrameAccess.READ_WRITE || access == FrameInstance.FrameAccess.MATERIALIZE) && inspectedFrame.isVirtual(1)) {
            OptimizedCallTarget callTarget = (OptimizedCallTarget)this.getCallTarget();
            if (callTarget.engine.traceDeoptimizeFrame) {
                GraalTruffleRuntime.StackTraceHelper.logHostAndGuestStacktrace("FrameInstance#getFrame(MATERIALIZE)", callTarget);
            }
            inspectedFrame.materializeVirtualObjects(false);
        }
        Frame frame = (Frame)inspectedFrame.getLocal(1);
        if (access == FrameInstance.FrameAccess.MATERIALIZE) {
            frame = frame.materialize();
        }
        return frame;
    }

    @CompilerDirectives.TruffleBoundary
    public Frame getFrame(FrameInstance.FrameAccess access) {
        return this.getFrameFrom(this.callTargetFrame, access);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isVirtualFrame() {
        return this.callTargetFrame.isVirtual(1);
    }

    @CompilerDirectives.TruffleBoundary
    public int getCompilationTier() {
        return ((CompilationState)((Object)this.callTargetFrame.getLocal(2))).getTier();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isCompilationRoot() {
        return ((CompilationState)((Object)this.callTargetFrame.getLocal(2))).isCompilationRoot();
    }

    @CompilerDirectives.TruffleBoundary
    public CallTarget getCallTarget() {
        return (CallTarget)this.callTargetFrame.getLocal(0);
    }

    @CompilerDirectives.TruffleBoundary
    public final Node getCallNode() {
        Object receiver;
        if (this.callNodeFrame != null && (receiver = this.callNodeFrame.getLocal(1)) instanceof Node) {
            return (Node)receiver;
        }
        return null;
    }

    static {
        try {
            CALL_DIRECT = OptimizedCallTarget.class.getDeclaredMethod("callDirect", Node.class, Object[].class);
            CALL_INLINED = OptimizedCallTarget.class.getDeclaredMethod("callInlined", Node.class, Object[].class);
            CALL_INLINED_CALL = GraalRuntimeSupport.class.getDeclaredMethod("callInlined", Node.class, CallTarget.class, Object[].class);
            CALL_INDIRECT = OptimizedCallTarget.class.getDeclaredMethod("callIndirect", Node.class, Object[].class);
            CALL_TARGET_METHOD = OptimizedCallTarget.class.getDeclaredMethod("executeRootNode", VirtualFrame.class, CompilationState.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalError(e);
        }
    }
}

