/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.frame.Frame;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleInliningData;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

final class GraalTruffleRuntimeListenerDispatcher
extends CopyOnWriteArrayList<GraalTruffleRuntimeListener>
implements GraalTruffleRuntimeListener,
TruffleCompilerListener {
    GraalTruffleRuntimeListenerDispatcher() {
    }

    @Override
    public boolean add(GraalTruffleRuntimeListener e) {
        if (e != this && !this.contains(e)) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public void onCompilationSplit(OptimizedDirectCallNode callNode) {
        this.invokeListeners(l -> l.onCompilationSplit(callNode));
    }

    @Override
    public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
        this.invokeListeners(l -> l.onCompilationSplitFailed(callNode, reason));
    }

    @Override
    public void onCompilationQueued(OptimizedCallTarget target, int tier) {
        this.invokeListeners(l -> l.onCompilationQueued(target, tier));
    }

    @Override
    public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason, int tier) {
        this.invokeListeners(l -> l.onCompilationDequeued(target, source, reason, tier));
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanent, int tier) {
        this.invokeListeners(l -> l.onCompilationFailed(target, reason, bailout, permanent, tier));
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target, int tier) {
        this.invokeListeners(l -> l.onCompilationStarted(target, tier));
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target, TruffleCompilationTask task) {
        this.invokeListeners(l -> l.onCompilationStarted(target, task));
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        this.invokeListeners(l -> l.onCompilationTruffleTierFinished(target, inliningDecision, graph));
    }

    @Override
    public void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
        this.invokeListeners(l -> l.onCompilationGraalTierFinished(target, graph));
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result, int tier) {
        this.invokeListeners(l -> l.onCompilationSuccess(target, inliningDecision, graph, result, tier));
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        this.invokeListeners(l -> l.onCompilationInvalidated(target, source, reason));
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        this.invokeListeners(l -> l.onCompilationDeoptimized(target, frame));
    }

    @Override
    public void onShutdown() {
        this.invokeListeners(l -> l.onShutdown());
    }

    @Override
    public void onEngineClosed(EngineData runtimeData) {
        this.invokeListeners(l -> l.onEngineClosed(runtimeData));
    }

    private void invokeListeners(Consumer<? super GraalTruffleRuntimeListener> action) {
        Throwable exception = null;
        for (GraalTruffleRuntimeListener l : this) {
            try {
                action.accept(l);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                if (exception == null) {
                    exception = t;
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        if (exception != null) {
            throw GraalTruffleRuntimeListenerDispatcher.sthrow(RuntimeException.class, exception);
        }
    }

    private static <E extends Throwable> RuntimeException sthrow(Class<E> type, Throwable ex) throws E {
        throw ex;
    }

    @Override
    public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleInliningData inliningPlan, TruffleCompilerListener.GraphInfo graph) {
        this.onCompilationTruffleTierFinished((OptimizedCallTarget)compilable, (TruffleInlining)inliningPlan, graph);
    }

    @Override
    public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
        this.onCompilationGraalTierFinished((OptimizedCallTarget)compilable, graph);
    }

    @Override
    public void onSuccess(CompilableTruffleAST compilable, TruffleInliningData inliningPlan, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result, int tier) {
        this.onCompilationSuccess((OptimizedCallTarget)compilable, (TruffleInlining)inliningPlan, graph, result, tier);
    }

    @Override
    public void onFailure(CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout, int tier) {
        this.onCompilationFailed((OptimizedCallTarget)compilable, reason, bailout, permanentBailout, tier);
    }

    @Override
    public void onCompilationRetry(CompilableTruffleAST compilable, TruffleCompilationTask task) {
        this.onCompilationQueued((OptimizedCallTarget)compilable, task.tier());
        this.onCompilationStarted((OptimizedCallTarget)compilable, task);
    }
}

