/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.impl.AbstractAssumption;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.options.OptionValues;

public final class OptimizedAssumption
extends AbstractAssumption
implements JavaKind.FormatWithToString {
    private Entry dependencies;
    private int size;
    private int sizeAfterLastRemove;

    public OptimizedAssumption(String name) {
        super(name);
    }

    public void check() throws InvalidAssumptionException {
        if (!this.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new InvalidAssumptionException();
        }
    }

    public void invalidate() {
        if (this.isValid) {
            this.invalidateImpl("");
        }
    }

    public void invalidate(String message) {
        if (this.isValid) {
            this.invalidateImpl(message);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void invalidateImpl(String message) {
        if (!this.isValid) {
            return;
        }
        OptionValues engineOptions = null;
        TruffleLogger logger = null;
        boolean logStackTrace = false;
        Entry e = this.dependencies;
        CharSequence reason = null;
        while (e != null) {
            OptimizedAssumptionDependency dependency = e.awaitDependency();
            if (dependency != null) {
                if (reason == null) {
                    String useMessage;
                    String useName = this.name != null ? this.name : "";
                    String string = useMessage = message != null ? message : "";
                    reason = useName.isEmpty() && useMessage.isEmpty() ? "assumption invalidated" : (useName.isEmpty() ? useMessage : (useMessage.isEmpty() ? useName : new LazyReason(useName, useMessage)));
                }
                dependency.onAssumptionInvalidated((Object)this, reason);
                if (engineOptions == null) {
                    OptimizedCallTarget callTarget = (OptimizedCallTarget)dependency.getCompilable();
                    if (callTarget != null) {
                        engineOptions = callTarget.getOptionValues();
                        logger = callTarget.engine.getEngineLogger();
                    } else {
                        EngineData engineData = GraalTVMCI.getEngineData(null);
                        engineOptions = engineData.engineOptions;
                        logger = engineData.getEngineLogger();
                    }
                }
                if (((Boolean)engineOptions.get(PolyglotCompilerOptions.TraceAssumptions)).booleanValue()) {
                    logStackTrace = true;
                    this.logInvalidatedDependency(dependency, message, logger);
                }
            }
            e = e.next;
        }
        this.dependencies = null;
        this.size = 0;
        this.sizeAfterLastRemove = 0;
        this.isValid = false;
        if (logStackTrace) {
            OptimizedAssumption.logStackTrace(engineOptions, logger);
        }
    }

    private void removeInvalidEntries() {
        Entry last = null;
        Entry e = this.dependencies;
        this.dependencies = null;
        while (e != null) {
            if (e.isValid()) {
                if (last == null) {
                    this.dependencies = e;
                } else {
                    last.next = e;
                }
                last = e;
            } else {
                --this.size;
            }
            e = e.next;
        }
        if (last != null) {
            last.next = null;
        }
        this.sizeAfterLastRemove = this.size;
    }

    public synchronized void removeInvalidDependencies() {
        this.removeInvalidEntries();
    }

    public synchronized int countDependencies() {
        return this.size;
    }

    public synchronized Consumer<OptimizedAssumptionDependency> registerDependency() {
        if (this.isValid) {
            if (this.size >= 2 * this.sizeAfterLastRemove) {
                this.removeInvalidEntries();
            }
            Entry e = new Entry();
            e.next = this.dependencies;
            this.dependencies = e;
            ++this.size;
            return e;
        }
        return null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void logInvalidatedDependency(OptimizedAssumptionDependency dependency, String message, TruffleLogger logger) {
        StringBuilder sb = new StringBuilder("assumption '").append(this.name).append("' invalidated installed code '").append(dependency);
        if (message != null && !message.isEmpty()) {
            sb.append("' with message '").append(message);
        }
        logger.log(Level.INFO, sb.append("'").toString());
    }

    private static void logStackTrace(OptionValues engineOptions, TruffleLogger logger) {
        boolean skip = true;
        int limit = (Integer)engineOptions.get(PolyglotCompilerOptions.TraceStackTraceLimit);
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StringBuilder strb = new StringBuilder();
        String sep = "";
        for (int i = 1; i < stackTrace.length && i < 1 + limit; ++i) {
            strb.append(sep).append("  ").append(stackTrace[i].toString());
            sep = "\n";
        }
        if (stackTrace.length > 1 + limit) {
            strb.append("\n    ...");
        }
        logger.log(Level.INFO, strb.toString());
    }

    private static final class LazyReason
    implements CharSequence {
        private final String assumptionName;
        private final String message;
        private String strValue;

        LazyReason(String assumptionName, String message) {
            this.assumptionName = assumptionName;
            this.message = message;
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            if (this.strValue == null) {
                this.strValue = this.assumptionName + ' ' + this.message;
            }
            return this.strValue;
        }
    }

    static class Entry
    implements Consumer<OptimizedAssumptionDependency> {
        OptimizedAssumptionDependency dependency;
        WeakReference<OptimizedAssumptionDependency> weakDependency;
        Entry next;

        Entry() {
        }

        @Override
        public synchronized void accept(OptimizedAssumptionDependency dep) {
            if (dep == null || dep.soleExecutionEntryPoint()) {
                this.weakDependency = new WeakReference<OptimizedAssumptionDependency>(dep);
            } else {
                this.dependency = dep;
            }
            this.notifyAll();
        }

        synchronized OptimizedAssumptionDependency awaitDependency() {
            boolean interrupted = false;
            while (this.dependency == null && this.weakDependency == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.dependency != null) {
                return this.dependency;
            }
            return (OptimizedAssumptionDependency)this.weakDependency.get();
        }

        synchronized boolean isValid() {
            if (this.dependency != null) {
                return this.dependency.isValid();
            }
            if (this.weakDependency != null) {
                OptimizedAssumptionDependency dep = (OptimizedAssumptionDependency)this.weakDependency.get();
                return dep != null && dep.isValid();
            }
            return true;
        }

        public synchronized String toString() {
            if (this.dependency != null) {
                return String.format("%x[%s]", this.hashCode(), this.dependency);
            }
            if (this.weakDependency != null) {
                OptimizedAssumptionDependency dep = (OptimizedAssumptionDependency)this.weakDependency.get();
                return String.format("%x[%s]", this.hashCode(), dep);
            }
            return String.format("%x", this.hashCode());
        }
    }
}

