/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.UnpackEndianHalfNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.virtual.phases.ea.GraphEffectList;
import org.graalvm.compiler.virtual.phases.ea.ObjectState;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeBlockState;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeClosure;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;

class VirtualizerToolImpl
extends CoreProvidersDelegate
implements VirtualizerTool,
CanonicalizerTool {
    private final PartialEscapeClosure<?> closure;
    private final Assumptions assumptions;
    private final OptionValues options;
    private final DebugContext debug;
    private ConstantNode illegalConstant;
    private boolean deleted;
    private PartialEscapeBlockState<?> state;
    private ValueNode current;
    private FixedNode position;
    private GraphEffectList effects;

    VirtualizerToolImpl(CoreProviders providers, PartialEscapeClosure<?> closure, Assumptions assumptions, OptionValues options, DebugContext debug) {
        super(providers);
        this.closure = closure;
        this.assumptions = assumptions;
        this.options = options;
        this.debug = debug;
    }

    @Override
    public OptionValues getOptions() {
        return this.options;
    }

    @Override
    public DebugContext getDebug() {
        return this.debug;
    }

    public void reset(PartialEscapeBlockState<?> newState, ValueNode newCurrent, FixedNode newPosition, GraphEffectList newEffects) {
        this.deleted = false;
        this.state = newState;
        this.current = newCurrent;
        this.position = newPosition;
        this.effects = newEffects;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public ValueNode getAlias(ValueNode value) {
        return this.closure.getAliasAndResolve(this.state, value);
    }

    @Override
    public ValueNode getEntry(VirtualObjectNode virtualObject, int index) {
        return this.state.getObjectState(virtualObject).getEntry(index);
    }

    @Override
    public boolean setVirtualEntry(VirtualObjectNode virtual, int index, ValueNode value, JavaKind theAccessKind, long offset) {
        JavaKind accessKind;
        JavaKind entryKind;
        block15: {
            boolean oldIsIllegal;
            block18: {
                block16: {
                    ValueNode oldValue;
                    block17: {
                        boolean canVirtualize;
                        ObjectState obj = this.state.getObjectState(virtual);
                        assert (obj.isVirtual()) : "not virtual: " + obj;
                        entryKind = virtual.entryKind(this.getMetaAccessExtensionProvider(), index);
                        accessKind = theAccessKind != null ? theAccessKind : entryKind;
                        ValueNode newValue = this.closure.getAliasAndResolve(this.state, value);
                        this.getDebug().log(4, "Setting entry %d in virtual object %s %s results in %s", (Object)index, (Object)virtual.getObjectId(), (Object)virtual, (Object)this.state.getObjectState(virtual.getObjectId()));
                        oldValue = this.getEntry(virtual, index);
                        oldIsIllegal = oldValue.isIllegalConstant();
                        boolean bl = canVirtualize = entryKind == accessKind || entryKind == accessKind.getStackKind() && virtual instanceof VirtualInstanceNode;
                        if (!canVirtualize) {
                            int accessLastIndex;
                            assert (entryKind != JavaKind.Long || newValue != null);
                            if (entryKind == JavaKind.Long && oldValue.getStackKind() == newValue.getStackKind() && oldValue.getStackKind().isPrimitive()) {
                                this.getDebug().log(4, "virtualizing %s with primitive of kind %s in long entry ", (Object)this.current, (Object)oldValue.getStackKind());
                                canVirtualize = true;
                            } else if (entryKind == JavaKind.Int && (accessKind == JavaKind.Long || accessKind == JavaKind.Double) && offset % 8L == 0L) {
                                int nextIndex = virtual.entryIndexForOffset(this.getMetaAccess(), offset + 4L, JavaKind.Int);
                                if (nextIndex != -1) {
                                    canVirtualize = true;
                                    assert (nextIndex == index + 1) : "expected to be sequential";
                                    this.getDebug().log(4, "virtualizing %s for double word stored in two ints", (Object)this.current);
                                }
                            } else if (this.canVirtualizeLargeByteArrayUnsafeWrite(virtual, accessKind, offset) && (accessLastIndex = virtual.entryIndexForOffset(this.getMetaAccess(), offset + (long)accessKind.getByteCount() - 1L, JavaKind.Byte)) != -1 && !oldIsIllegal && this.canStoreOverOldValue((VirtualArrayNode)virtual, oldValue, accessKind, index)) {
                                canVirtualize = true;
                                this.getDebug().log(4, "virtualizing %s for %s word stored in byte array", (Object)this.current, (Object)accessKind);
                            }
                        }
                        if (!canVirtualize) break block15;
                        this.getDebug().log(4, "virtualizing %s for entryKind %s and access kind %s", (Object)this.current, (Object)entryKind, (Object)accessKind);
                        this.state.setEntry(virtual.getObjectId(), index, newValue);
                        if (entryKind != JavaKind.Int) break block16;
                        if (!accessKind.needsTwoSlots()) break block17;
                        assert (virtual.entryKind(this.getMetaAccessExtensionProvider(), index + 1) == JavaKind.Int);
                        this.state.setEntry(virtual.getObjectId(), index + 1, this.getIllegalConstant());
                        break block18;
                    }
                    if (oldValue.getStackKind() != JavaKind.Double && oldValue.getStackKind() != JavaKind.Long) break block18;
                    this.getDebug().log(4, "virtualizing %s producing second half of double word value %s", (Object)this.current, (Object)oldValue);
                    ValueNode secondHalf = UnpackEndianHalfNode.create(oldValue, false, NodeView.DEFAULT);
                    this.addNode(secondHalf);
                    this.state.setEntry(virtual.getObjectId(), index + 1, secondHalf);
                    break block18;
                }
                if (this.canVirtualizeLargeByteArrayUnsafeWrite(virtual, accessKind, offset)) {
                    for (int i = index + 1; i < index + accessKind.getByteCount(); ++i) {
                        this.state.setEntry(virtual.getObjectId(), i, this.getIllegalConstant());
                    }
                }
            }
            if (oldIsIllegal && entryKind == JavaKind.Int) {
                ValueNode previous = this.getEntry(virtual, index - 1);
                this.getDebug().log(4, "virtualizing %s producing first half of double word value %s", (Object)this.current, (Object)previous);
                ValueNode firstHalf = UnpackEndianHalfNode.create(previous, true, NodeView.DEFAULT);
                this.addNode(firstHalf);
                this.state.setEntry(virtual.getObjectId(), index - 1, firstHalf);
            }
            return true;
        }
        assert (entryKind != accessKind);
        return false;
    }

    private boolean canStoreOverOldValue(VirtualArrayNode virtual, ValueNode oldValue, JavaKind accessKind, int index) {
        if (!oldValue.getStackKind().isPrimitive()) {
            return false;
        }
        if (this.isEntryDefaults(virtual, accessKind.getByteCount(), index)) {
            return true;
        }
        return accessKind.getByteCount() == virtual.byteArrayEntryByteCount(index, this);
    }

    private boolean canVirtualizeLargeByteArrayUnsafeWrite(VirtualObjectNode virtual, JavaKind accessKind, long offset) {
        return this.canVirtualizeLargeByteArrayUnsafeAccess() && virtual.isVirtualByteArrayAccess(this.getMetaAccessExtensionProvider(), accessKind) && offset % (long)accessKind.getByteCount() == 0L;
    }

    int getVirtualByteCount(ValueNode[] entries, int startIndex) {
        int pos;
        for (pos = startIndex + 1; pos < entries.length && entries[pos].getStackKind() == JavaKind.Illegal; ++pos) {
        }
        return pos - startIndex;
    }

    boolean isEntryDefaults(ObjectState object, int byteCount, int index) {
        for (int i = index; i < index + byteCount; ++i) {
            if (object.getEntry(i).isDefaultConstant()) continue;
            return false;
        }
        return true;
    }

    boolean isEntryDefaults(VirtualObjectNode virtual, int byteCount, int index) {
        return this.isEntryDefaults(this.state.getObjectState(virtual), byteCount, index);
    }

    public ValueNode getIllegalConstant() {
        if (this.illegalConstant == null) {
            this.illegalConstant = ConstantNode.forConstant((JavaConstant)JavaConstant.forIllegal(), this.getMetaAccess(), this.closure.cfg.graph);
        }
        return this.illegalConstant;
    }

    @Override
    public void setEnsureVirtualized(VirtualObjectNode virtualObject, boolean ensureVirtualized) {
        int id = virtualObject.getObjectId();
        this.state.setEnsureVirtualized(id, ensureVirtualized);
    }

    @Override
    public boolean getEnsureVirtualized(VirtualObjectNode virtualObject) {
        return this.state.getObjectState(virtualObject).getEnsureVirtualized();
    }

    @Override
    public void replaceWithVirtual(VirtualObjectNode virtual) {
        this.closure.addVirtualAlias(virtual, this.current);
        this.effects.deleteNode(this.current);
        this.deleted = true;
    }

    @Override
    public void replaceWithValue(ValueNode replacement) {
        this.effects.replaceAtUsages(this.current, this.closure.getScalarAlias(replacement), this.position);
        this.closure.addScalarAlias(this.current, replacement);
        this.deleted = true;
    }

    @Override
    public void delete() {
        this.effects.deleteNode(this.current);
        this.deleted = true;
    }

    @Override
    public void replaceFirstInput(Node oldInput, Node replacement) {
        this.effects.replaceFirstInput(this.current, oldInput, replacement);
    }

    @Override
    public void addNode(ValueNode node) {
        if (node instanceof FloatingNode) {
            this.effects.addFloatingNode(node, "VirtualizerTool");
        } else {
            this.effects.addFixedNodeBefore((FixedWithNextNode)node, this.position);
        }
    }

    @Override
    public void createVirtualObject(VirtualObjectNode virtualObject, ValueNode[] entryState, List<MonitorIdNode> locks, NodeSourcePosition sourcePosition, boolean ensureVirtualized) {
        VirtualUtil.trace(this.options, this.debug, "{{%s}} ", this.current);
        if (!virtualObject.isAlive()) {
            this.effects.addFloatingNode(virtualObject, "newVirtualObject");
        }
        for (int i = 0; i < entryState.length; ++i) {
            ValueNode entry = entryState[i];
            entryState[i] = entry instanceof VirtualObjectNode ? entry : this.closure.getAliasAndResolve(this.state, entry);
        }
        int id = virtualObject.getObjectId();
        if (id == -1) {
            id = this.closure.virtualObjects.size();
            this.closure.virtualObjects.add(virtualObject);
            virtualObject.setObjectId(id);
        }
        this.state.addObject(id, new ObjectState(entryState, locks, ensureVirtualized));
        this.closure.addVirtualAlias(virtualObject, virtualObject);
        PartialEscapeClosure.COUNTER_ALLOCATION_REMOVED.increment(this.debug);
        this.effects.addVirtualizationDelta(1);
        if (sourcePosition != null) {
            assert (virtualObject.getNodeSourcePosition() == null || virtualObject.getNodeSourcePosition() == sourcePosition) : "unexpected source pos!";
            virtualObject.setNodeSourcePosition(sourcePosition);
        }
    }

    @Override
    public int getMaximumEntryCount() {
        return GraalOptions.MaximumEscapeAnalysisArrayLength.getValue(this.current.getOptions());
    }

    @Override
    public void replaceWith(ValueNode node) {
        if (node instanceof VirtualObjectNode) {
            this.replaceWithVirtual((VirtualObjectNode)node);
        } else {
            this.replaceWithValue(node);
        }
    }

    @Override
    public boolean ensureMaterialized(VirtualObjectNode virtualObject) {
        return this.closure.ensureMaterialized(this.state, virtualObject.getObjectId(), this.position, this.effects, PartialEscapeClosure.COUNTER_MATERIALIZATIONS_UNHANDLED);
    }

    @Override
    public void addLock(VirtualObjectNode virtualObject, MonitorIdNode monitorId) {
        int id = virtualObject.getObjectId();
        this.state.addLock(id, monitorId);
    }

    @Override
    public MonitorIdNode removeLock(VirtualObjectNode virtualObject) {
        int id = virtualObject.getObjectId();
        return this.state.removeLock(id);
    }

    @Override
    public boolean canVirtualizeLargeByteArrayUnsafeAccess() {
        if (this.getPlatformConfigurationProvider() != null) {
            return this.getPlatformConfigurationProvider().canVirtualizeLargeByteArrayAccess();
        }
        return false;
    }

    @Override
    public boolean canonicalizeReads() {
        return false;
    }

    @Override
    public boolean allUsagesAvailable() {
        return true;
    }

    @Override
    public Assumptions getAssumptions() {
        return this.assumptions;
    }

    @Override
    public Integer smallestCompareWidth() {
        if (this.getLowerer() != null) {
            return this.getLowerer().smallestCompareWidth();
        }
        return null;
    }

    @Override
    public boolean supportsRounding() {
        return this.getLowerer().supportsRounding();
    }
}

