/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.jniutils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jdk.vm.ci.services.Services;
import org.graalvm.jniutils.NativeBridgeSupport;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CDoublePointer;
import org.graalvm.nativeimage.c.type.CFloatPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JNI {
    public static final int JNI_OK = 0;
    public static final int JNI_ERR = -1;
    public static final int JNI_EDETACHED = -2;
    public static final int JNI_EVERSION = -3;
    public static final int JNI_ENOMEM = -4;
    public static final int JNI_EEXIST = -5;
    public static final int JNI_EINVAL = -6;
    public static final int JNI_VERSION_1_8 = 65544;

    private JNI() {
        throw new IllegalStateException("No instance allowed");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class JNIHeaderDirectives
    implements CContext.Directives {
        private static final String[] INCLUDES = new String[]{"jni.h", "jni_md.h"};

        JNIHeaderDirectives() {
        }

        public boolean isInConfiguration() {
            return ImageSingletons.contains(NativeBridgeSupport.class);
        }

        public List<String> getOptions() {
            return Arrays.stream(JNIHeaderDirectives.findJNIHeaders()).map(p -> "-I" + p.getParent()).collect(Collectors.toList());
        }

        public List<String> getHeaderFiles() {
            return Arrays.stream(JNIHeaderDirectives.findJNIHeaders()).map(p -> '<' + p.toString() + '>').collect(Collectors.toList());
        }

        private static Path[] findJNIHeaders() {
            Path parent;
            Path javaHome = Paths.get((String)Services.getSavedProperties().get("java.home"), new String[0]);
            Path includeFolder = javaHome.resolve("include");
            if (!Files.exists(includeFolder, new LinkOption[0]) && (parent = javaHome.getParent()) != null) {
                javaHome = parent;
            }
            if (!Files.exists(includeFolder = javaHome.resolve("include"), new LinkOption[0])) {
                throw new IllegalStateException("Cannot find 'include' folder in JDK.");
            }
            Path[] res = new Path[INCLUDES.length];
            try {
                for (int i = 0; i < INCLUDES.length; ++i) {
                    String include = INCLUDES[i];
                    Optional<Path> includeFile = Files.find(includeFolder, 2, (p, attrs) -> include.equals(p.getFileName().toString()), new FileVisitOption[0]).findFirst();
                    if (!includeFile.isPresent()) {
                        throw new IllegalStateException("Include: " + res[i] + " does not exist.");
                    }
                    res[i] = includeFile.get();
                }
                return res;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetEnv
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JavaVM var1, JNIEnvPointer var2, int var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DetachCurrentThread
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JavaVM var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface AttachCurrentThreadAsDaemon
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JavaVM var1, JNIEnvPointer var2, JavaVMAttachArgs var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface AttachCurrentThread
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JavaVM var1, JNIEnvPointer var2, JavaVMAttachArgs var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetJavaVM
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JavaVMPointer var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetStaticBooleanField
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JClass var2, JFieldID var3, boolean var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStaticBooleanField
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JClass var2, JFieldID var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetIntField
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JObject var2, JFieldID var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStaticObjectField
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JClass var2, JFieldID var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetFieldID
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JFieldID call(JNIEnv var1, JClass var2, CCharPointer var3, CCharPointer var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStaticFieldID
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JFieldID call(JNIEnv var1, JClass var2, CCharPointer var3, CCharPointer var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface IsInstanceOf
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JObject var2, JClass var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetDirectBufferAddress
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public VoidPointer call(JNIEnv var1, JObject var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Throw
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JThrowable var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetObjectArrayElement
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JObjectArray var2, int var3, JObject var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseStringUTFChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JString var2, CCharPointer var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseStringChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JString var2, CShortPointer var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetDoubleArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JDoubleArray var2, int var3, int var4, CDoublePointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetFloatArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JFloatArray var2, int var3, int var4, CFloatPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetLongArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JLongArray var2, int var3, int var4, CLongPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetIntArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JIntArray var2, int var3, int var4, CIntPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetShortArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JShortArray var2, int var3, int var4, CShortPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetCharArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JCharArray var2, int var3, int var4, CShortPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetByteArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JByteArray var2, int var3, int var4, CCharPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface SetBooleanArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JBooleanArray var2, int var3, int var4, CCharPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetDoubleArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JDoubleArray var2, int var3, int var4, CDoublePointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetFloatArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JFloatArray var2, int var3, int var4, CFloatPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetLongArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JLongArray var2, int var3, int var4, CLongPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetIntArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JIntArray var2, int var3, int var4, CIntPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetShortArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JShortArray var2, int var3, int var4, CShortPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetCharArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JCharArray var2, int var3, int var4, CShortPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetByteArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JByteArray var2, int var3, int var4, CCharPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetBooleanArrayRegion
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JBooleanArray var2, int var3, int var4, CCharPointer var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseDoubleArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JDoubleArray var2, CDoublePointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseFloatArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JFloatArray var2, CFloatPointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseLongArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JLongArray var2, CLongPointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseIntArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JIntArray var2, CIntPointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseShortArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JShortArray var2, CShortPointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseCharArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JCharArray var2, CShortPointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseByteArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JByteArray var2, CCharPointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ReleaseBooleanArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JBooleanArray var2, CCharPointer var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewStringUTF8
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JString call(JNIEnv var1, CCharPointer var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewString
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JString call(JNIEnv var1, CShortPointer var2, int var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewObjectArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObjectArray call(JNIEnv var1, int var2, JClass var3, JObject var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewObjectA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewGlobalRef
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObject var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewDoubleArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JDoubleArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewFloatArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JFloatArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewLongArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JLongArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewIntArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JIntArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewShortArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JShortArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewCharArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JCharArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewByteArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JByteArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface NewBooleanArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JBooleanArray call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface IsSameObject
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JObject var2, JObject var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStringUTFLength
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JString var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStringUTFChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CCharPointer call(JNIEnv var1, JString var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStringLength
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JString var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStringChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CShortPointer call(JNIEnv var1, JString var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetStaticMethodID
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JMethodID call(JNIEnv var1, JClass var2, CCharPointer var3, CCharPointer var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetObjectRefType
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JObject var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetObjectClass
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JClass call(JNIEnv var1, JObject var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetObjectArrayElement
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObjectArray var2, int var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetMethodID
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JMethodID call(JNIEnv var1, JClass var2, CCharPointer var3, CCharPointer var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetDoubleArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CDoublePointer call(JNIEnv var1, JDoubleArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetFloatArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CFloatPointer call(JNIEnv var1, JFloatArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetLongArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CLongPointer call(JNIEnv var1, JLongArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetIntArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CIntPointer call(JNIEnv var1, JIntArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetShortArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CShortPointer call(JNIEnv var1, JShortArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetCharArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CShortPointer call(JNIEnv var1, JCharArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetByteArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CCharPointer call(JNIEnv var1, JByteArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetBooleanArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CCharPointer call(JNIEnv var1, JBooleanArray var2, JValue var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface GetArrayLength
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JArray var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DefineClass
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JClass call(JNIEnv var1, CCharPointer var2, JObject var3, CCharPointer var4, long var5);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface FindClass
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JClass call(JNIEnv var1, CCharPointer var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ExceptionOccurred
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JThrowable call(JNIEnv var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ExceptionDescribe
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ExceptionClear
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ExceptionCheck
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface PopLocalFrame
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObject var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface PushLocalFrame
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DeleteLocalRef
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JObject var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DeleteGlobalRef
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JObject var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallCharMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public char call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallByteMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public byte call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallFloatMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public float call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallDoubleMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public double call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallLongMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public long call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallIntMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallShortMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public short call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallBooleanMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallVoidMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallObjectMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallStaticLongMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public long call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallStaticObjectMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallStaticVoidMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallStaticBooleanMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface CallStaticIntMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="JNIInvokeInterface_", addStructKeyword=true)
    public static interface JNIInvokeInterface
    extends PointerBase {
        @CField(value="AttachCurrentThread")
        public AttachCurrentThread getAttachCurrentThread();

        @CField(value="AttachCurrentThreadAsDaemon")
        public AttachCurrentThreadAsDaemon getAttachCurrentThreadAsDaemon();

        @CField(value="DetachCurrentThread")
        public DetachCurrentThread getDetachCurrentThread();

        @CField(value="GetEnv")
        public GetEnv getGetEnv();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="JavaVMAttachArgs", addStructKeyword=true)
    public static interface JavaVMAttachArgs
    extends PointerBase {
        @CField(value="version")
        public int getVersion();

        @CField(value="version")
        public void setVersion(int var1);

        @CField(value="name")
        public CCharPointer getName();

        @CField(value="name")
        public void setName(CCharPointer var1);

        @CField(value="group")
        public JObject getGroup();

        @CField(value="group")
        public void setGroup(JObject var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CPointerTo(value=JavaVM.class)
    public static interface JavaVMPointer
    extends PointerBase {
        public JavaVM readJavaVM();

        public void writeJavaVM(JavaVM var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="JavaVM_", addStructKeyword=true)
    public static interface JavaVM
    extends PointerBase {
        @CField(value="functions")
        public JNIInvokeInterface getFunctions();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="JNINativeInterface_", addStructKeyword=true)
    public static interface JNINativeInterface
    extends PointerBase {
        @CField(value="NewString")
        public NewString getNewString();

        @CField(value="GetStringLength")
        public GetStringLength getGetStringLength();

        @CField(value="GetStringChars")
        public GetStringChars getGetStringChars();

        @CField(value="ReleaseStringChars")
        public ReleaseStringChars getReleaseStringChars();

        @CField(value="NewStringUTF")
        public NewStringUTF8 getNewStringUTF();

        @CField(value="GetStringUTFLength")
        public GetStringUTFLength getGetStringUTFLength();

        @CField(value="GetStringUTFChars")
        public GetStringUTFChars getGetStringUTFChars();

        @CField(value="ReleaseStringUTFChars")
        public ReleaseStringUTFChars getReleaseStringUTFChars();

        @CField(value="GetArrayLength")
        public GetArrayLength getGetArrayLength();

        @CField(value="NewObjectArray")
        public NewObjectArray getNewObjectArray();

        @CField(value="NewBooleanArray")
        public NewBooleanArray getNewBooleanArray();

        @CField(value="NewByteArray")
        public NewByteArray getNewByteArray();

        @CField(value="NewCharArray")
        public NewCharArray getNewCharArray();

        @CField(value="NewShortArray")
        public NewShortArray getNewShortArray();

        @CField(value="NewIntArray")
        public NewIntArray getNewIntArray();

        @CField(value="NewLongArray")
        public NewLongArray getNewLongArray();

        @CField(value="NewFloatArray")
        public NewFloatArray getNewFloatArray();

        @CField(value="NewDoubleArray")
        public NewDoubleArray getNewDoubleArray();

        @CField(value="GetObjectArrayElement")
        public GetObjectArrayElement getGetObjectArrayElement();

        @CField(value="SetObjectArrayElement")
        public SetObjectArrayElement getSetObjectArrayElement();

        @CField(value="GetBooleanArrayElements")
        public GetBooleanArrayElements getGetBooleanArrayElements();

        @CField(value="GetByteArrayElements")
        public GetByteArrayElements getGetByteArrayElements();

        @CField(value="GetCharArrayElements")
        public GetCharArrayElements getGetCharArrayElements();

        @CField(value="GetShortArrayElements")
        public GetShortArrayElements getGetShortArrayElements();

        @CField(value="GetIntArrayElements")
        public GetIntArrayElements getGetIntArrayElements();

        @CField(value="GetLongArrayElements")
        public GetLongArrayElements getGetLongArrayElements();

        @CField(value="GetFloatArrayElements")
        public GetFloatArrayElements getGetFloatArrayElements();

        @CField(value="GetDoubleArrayElements")
        public GetDoubleArrayElements getGetDoubleArrayElements();

        @CField(value="ReleaseBooleanArrayElements")
        public ReleaseBooleanArrayElements getReleaseBooleanArrayElements();

        @CField(value="ReleaseByteArrayElements")
        public ReleaseByteArrayElements getReleaseByteArrayElements();

        @CField(value="ReleaseCharArrayElements")
        public ReleaseCharArrayElements getReleaseCharArrayElements();

        @CField(value="ReleaseShortArrayElements")
        public ReleaseShortArrayElements getReleaseShortArrayElements();

        @CField(value="ReleaseIntArrayElements")
        public ReleaseIntArrayElements getReleaseIntArrayElements();

        @CField(value="ReleaseLongArrayElements")
        public ReleaseLongArrayElements getReleaseLongArrayElements();

        @CField(value="ReleaseFloatArrayElements")
        public ReleaseFloatArrayElements getReleaseFloatArrayElements();

        @CField(value="ReleaseDoubleArrayElements")
        public ReleaseDoubleArrayElements getReleaseDoubleArrayElements();

        @CField(value="GetBooleanArrayRegion")
        public GetBooleanArrayRegion getGetBooleanArrayRegion();

        @CField(value="GetByteArrayRegion")
        public GetByteArrayRegion getGetByteArrayRegion();

        @CField(value="GetCharArrayRegion")
        public GetCharArrayRegion getGetCharArrayRegion();

        @CField(value="GetShortArrayRegion")
        public GetShortArrayRegion getGetShortArrayRegion();

        @CField(value="GetIntArrayRegion")
        public GetIntArrayRegion getGetIntArrayRegion();

        @CField(value="GetLongArrayRegion")
        public GetLongArrayRegion getGetLongArrayRegion();

        @CField(value="GetFloatArrayRegion")
        public GetFloatArrayRegion getGetFloatArrayRegion();

        @CField(value="GetDoubleArrayRegion")
        public GetDoubleArrayRegion getGetDoubleArrayRegion();

        @CField(value="SetBooleanArrayRegion")
        public SetBooleanArrayRegion getSetBooleanArrayRegion();

        @CField(value="SetByteArrayRegion")
        public SetByteArrayRegion getSetByteArrayRegion();

        @CField(value="SetCharArrayRegion")
        public SetCharArrayRegion getSetCharArrayRegion();

        @CField(value="SetShortArrayRegion")
        public SetShortArrayRegion getSetShortArrayRegion();

        @CField(value="SetIntArrayRegion")
        public SetIntArrayRegion getSetIntArrayRegion();

        @CField(value="SetLongArrayRegion")
        public SetLongArrayRegion getSetLongArrayRegion();

        @CField(value="SetFloatArrayRegion")
        public SetFloatArrayRegion getSetFloatArrayRegion();

        @CField(value="SetDoubleArrayRegion")
        public SetDoubleArrayRegion getSetDoubleArrayRegion();

        @CField(value="FindClass")
        public FindClass getFindClass();

        @CField(value="DefineClass")
        public DefineClass getDefineClass();

        @CField(value="IsSameObject")
        public IsSameObject getIsSameObject();

        @CField(value="GetObjectClass")
        public GetObjectClass getGetObjectClass();

        @CField(value="NewGlobalRef")
        public NewGlobalRef getNewGlobalRef();

        @CField(value="DeleteGlobalRef")
        public DeleteGlobalRef getDeleteGlobalRef();

        @CField(value="DeleteLocalRef")
        public DeleteLocalRef getDeleteLocalRef();

        @CField(value="PushLocalFrame")
        public PushLocalFrame getPushLocalFrame();

        @CField(value="PopLocalFrame")
        public PopLocalFrame getPopLocalFrame();

        @CField(value="NewObjectA")
        public NewObjectA getNewObjectA();

        @CField(value="GetStaticMethodID")
        public GetStaticMethodID getGetStaticMethodID();

        @CField(value="GetMethodID")
        public GetMethodID getGetMethodID();

        @CField(value="GetStaticFieldID")
        public GetStaticFieldID getGetStaticFieldID();

        @CField(value="GetFieldID")
        public GetFieldID getGetFieldID();

        @CField(value="CallStaticBooleanMethodA")
        public CallStaticBooleanMethodA getCallStaticBooleanMethodA();

        @CField(value="CallStaticIntMethodA")
        public CallStaticIntMethodA getCallStaticIntMethodA();

        @CField(value="CallStaticVoidMethodA")
        public CallStaticVoidMethodA getCallStaticVoidMethodA();

        @CField(value="CallStaticObjectMethodA")
        public CallStaticObjectMethodA getCallStaticObjectMethodA();

        @CField(value="CallStaticLongMethodA")
        public CallStaticLongMethodA getCallStaticLongMethodA();

        @CField(value="CallObjectMethodA")
        public CallObjectMethodA getCallObjectMethodA();

        @CField(value="CallVoidMethodA")
        public CallVoidMethodA getCallVoidMethodA();

        @CField(value="CallBooleanMethodA")
        public CallBooleanMethodA getCallBooleanMethodA();

        @CField(value="CallShortMethodA")
        public CallShortMethodA getCallShortMethodA();

        @CField(value="CallIntMethodA")
        public CallIntMethodA getCallIntMethodA();

        @CField(value="CallLongMethodA")
        public CallLongMethodA getCallLongMethodA();

        @CField(value="CallDoubleMethodA")
        public CallDoubleMethodA getCallDoubleMethodA();

        @CField(value="CallFloatMethodA")
        public CallFloatMethodA getCallFloatMethodA();

        @CField(value="CallByteMethodA")
        public CallByteMethodA getCallByteMethodA();

        @CField(value="CallCharMethodA")
        public CallCharMethodA getCallCharMethodA();

        @CField(value="GetStaticObjectField")
        public GetStaticObjectField getGetStaticObjectField();

        @CField(value="GetIntField")
        public GetIntField getGetIntField();

        @CField(value="GetStaticBooleanField")
        public GetStaticBooleanField getGetStaticBooleanField();

        @CField(value="SetStaticBooleanField")
        public SetStaticBooleanField getSetStaticBooleanField();

        @CField(value="ExceptionCheck")
        public ExceptionCheck getExceptionCheck();

        @CField(value="ExceptionOccurred")
        public ExceptionOccurred getExceptionOccurred();

        @CField(value="ExceptionClear")
        public ExceptionClear getExceptionClear();

        @CField(value="ExceptionDescribe")
        public ExceptionDescribe getExceptionDescribe();

        @CField(value="Throw")
        public Throw getThrow();

        @CField(value="GetObjectRefType")
        public GetObjectRefType getGetObjectRefType();

        @CField(value="GetDirectBufferAddress")
        public GetDirectBufferAddress getGetDirectBufferAddress();

        @CField(value="IsInstanceOf")
        public IsInstanceOf getIsInstanceOf();

        @CField(value="GetJavaVM")
        public GetJavaVM getGetJavaVM();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CPointerTo(value=JNIEnv.class)
    public static interface JNIEnvPointer
    extends PointerBase {
        public JNIEnv readJNIEnv();

        public void writeJNIEnv(JNIEnv var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="JNIEnv_", addStructKeyword=true)
    public static interface JNIEnv
    extends PointerBase {
        @CField(value="functions")
        public JNINativeInterface getFunctions();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="jvalue")
    public static interface JValue
    extends PointerBase {
        @CField(value="z")
        public boolean getBoolean();

        @CField(value="b")
        public byte getByte();

        @CField(value="c")
        public char getChar();

        @CField(value="s")
        public short getShort();

        @CField(value="i")
        public int getInt();

        @CField(value="j")
        public long getLong();

        @CField(value="f")
        public float getFloat();

        @CField(value="d")
        public double getDouble();

        @CField(value="l")
        public JObject getJObject();

        @CField(value="z")
        public void setBoolean(boolean var1);

        @CField(value="b")
        public void setByte(byte var1);

        @CField(value="c")
        public void setChar(char var1);

        @CField(value="s")
        public void setShort(short var1);

        @CField(value="i")
        public void setInt(int var1);

        @CField(value="j")
        public void setLong(long var1);

        @CField(value="f")
        public void setFloat(float var1);

        @CField(value="d")
        public void setDouble(double var1);

        @CField(value="l")
        public void setJObject(JObject var1);

        public JValue addressOf(int var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JThrowable
    extends JObject {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JString
    extends JObject {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JClass
    extends JObject {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JObjectArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JDoubleArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JFloatArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JLongArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JIntArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JShortArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JCharArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JByteArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JBooleanArray
    extends JArray {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JArray
    extends JObject {
        public static final int MODE_WRITE_RELEASE = 0;
        public static final int MODE_WRITE = 1;
        public static final int MODE_RELEASE = 2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JObject
    extends PointerBase {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JFieldID
    extends PointerBase {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface JMethodID
    extends PointerBase {
    }
}

