/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalIsolate;

public final class LibGraalScope
implements AutoCloseable {
    static final ThreadLocal<LibGraalScope> currentScope = new ThreadLocal();
    private final LibGraalScope parent;
    private final Shared shared;
    private static final AtomicInteger nextId = new AtomicInteger(1);
    private final int id;

    public static LibGraalScope current() {
        LibGraalScope scope = currentScope.get();
        if (scope == null) {
            throw new IllegalStateException("Not in an " + LibGraalScope.class.getSimpleName());
        }
        return scope;
    }

    public static long getIsolateThread() {
        return LibGraalScope.current().shared.getIsolateThread();
    }

    public LibGraalScope() {
        this(DetachAction.DETACH_RUNTIME);
    }

    public LibGraalScope(DetachAction detachAction) {
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        this.id = nextId.getAndIncrement();
        this.parent = currentScope.get();
        if (this.parent == null) {
            long[] isolateBox = new long[]{0L};
            boolean firstAttach = LibGraal.attachCurrentThread(false, isolateBox);
            long isolateAddress = isolateBox[0];
            long isolateThread = LibGraalScope.getIsolateThreadIn(isolateAddress);
            long isolateId = LibGraalScope.getIsolateId(isolateThread);
            LibGraalIsolate isolate = LibGraalIsolate.forIsolateId(isolateId, isolateAddress);
            this.shared = new Shared(firstAttach ? detachAction : null, isolate, isolateThread);
        } else {
            this.shared = this.parent.shared;
        }
        currentScope.set(this);
    }

    public String toString() {
        return String.format("LibGraalScope@%d[%s, parent=%s]", this.id, this.shared, this.parent);
    }

    public LibGraalScope(long isolateAddress) {
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        this.id = nextId.getAndIncrement();
        this.parent = currentScope.get();
        if (this.parent == null) {
            boolean alreadyAttached;
            long isolateThread = LibGraalScope.getIsolateThreadIn(isolateAddress);
            if (isolateThread == 0L) {
                alreadyAttached = false;
                isolateThread = LibGraalScope.attachThreadTo(isolateAddress);
            } else {
                alreadyAttached = true;
            }
            long isolateId = LibGraalScope.getIsolateId(isolateThread);
            LibGraalIsolate isolate = LibGraalIsolate.forIsolateId(isolateId, isolateAddress);
            this.shared = new Shared(alreadyAttached ? null : DetachAction.DETACH, isolate, isolateThread);
        } else {
            this.shared = this.parent.shared;
        }
        currentScope.set(this);
    }

    static native long attachThreadTo(long var0);

    static native void detachThreadFrom(long var0);

    static native long getIsolateThreadIn(long var0);

    private static native long getIsolateId(long var0);

    public LibGraalIsolate getIsolate() {
        return this.shared.isolate;
    }

    public long getIsolateThreadAddress() {
        return this.shared.getIsolateThread();
    }

    @Override
    public void close() {
        currentScope.set(this.parent);
        if (this.parent == null && this.shared.detachAction != null) {
            long isolateThread = this.shared.detach();
            if (this.shared.detachAction == DetachAction.DETACH) {
                LibGraalScope.detachThreadFrom(isolateThread);
            } else {
                LibGraal.detachCurrentThread(this.shared.detachAction == DetachAction.DETACH_RUNTIME_AND_RELEASE);
            }
        }
    }

    static Class<?>[] sig(Class<?> ... types) {
        return types;
    }

    public int getDepth() {
        int depth = 0;
        LibGraalScope ancestor = this.parent;
        while (ancestor != null) {
            ++depth;
            ancestor = ancestor.parent;
        }
        return depth;
    }

    static Method method(Class<?> declaringClass, String name, Class<?>[] ... sigs) {
        if (sigs.length == 1 || sigs.length == 0) {
            try {
                Class[] sig = sigs.length == 1 ? sigs[0] : new Class[]{};
                return declaringClass.getDeclaredMethod(name, sig);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw (NoSuchMethodError)new NoSuchMethodError(name).initCause(e);
            }
        }
        Method match = null;
        for (Method m : declaringClass.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            if (match != null) {
                throw new InternalError(String.format("Expected single method named %s, found %s and %s", name, match, m));
            }
            match = m;
        }
        if (match == null) {
            throw new NoSuchMethodError("Cannot find method " + name + " in " + declaringClass.getName());
        }
        Object[] parameterTypes = match.getParameterTypes();
        for (Object[] objectArray : sigs) {
            if (!Arrays.equals(parameterTypes, objectArray)) continue;
            return match;
        }
        throw new NoSuchMethodError(String.format("Unexpected signature for %s: %s", name, Arrays.toString(parameterTypes)));
    }

    static Method methodOrNull(Class<?> declaringClass, String name, Class<?>[] ... sigs) {
        try {
            return LibGraalScope.method(declaringClass, name, sigs);
        }
        catch (NoSuchMethodError e) {
            return null;
        }
    }

    static Method methodIf(Object guard, Class<?> declaringClass, String name, Class<?>[] ... sigs) {
        if (guard == null) {
            return null;
        }
        return LibGraalScope.method(declaringClass, name, sigs);
    }

    public static enum DetachAction {
        DETACH,
        DETACH_RUNTIME,
        DETACH_RUNTIME_AND_RELEASE;

    }

    static class Shared {
        final DetachAction detachAction;
        final LibGraalIsolate isolate;
        private long isolateThread;

        Shared(DetachAction detachAction, LibGraalIsolate isolate, long isolateThread) {
            this.detachAction = detachAction;
            this.isolate = isolate;
            this.isolateThread = isolateThread;
        }

        public long getIsolateThread() {
            if (this.isolateThread == 0L) {
                throw new IllegalStateException(Thread.currentThread() + " is no longer attached to " + this.isolate);
            }
            return this.isolateThread;
        }

        public long detach() {
            long res = this.getIsolateThread();
            this.isolateThread = 0L;
            return res;
        }

        public String toString() {
            return String.format("isolate=%s, isolateThread=0x%x, detachAction=%s", new Object[]{this.isolate, this.isolateThread, this.detachAction});
        }
    }
}

