/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class LibGraalJNIMethodScope
extends JNIMethodScope {
    private static volatile int lastJavaPCOffset = -1;

    private LibGraalJNIMethodScope(String scopeName, JNI.JNIEnv env) {
        super(scopeName, env);
        JNIUtil.PushLocalFrame(env, 64);
    }

    @Override
    public void close() {
        this.setObjectResult(JNIUtil.PopLocalFrame(this.getEnv(), this.getObjectResult()));
        super.close();
    }

    static JNIMethodScope open(String scopeName, JNI.JNIEnv env) {
        return LibGraalJNIMethodScope.scopeOrNull() == null && LibGraalJNIMethodScope.getJavaFrameAnchor().isNull() ? new LibGraalJNIMethodScope(scopeName, env) : new JNIMethodScope(scopeName, env);
    }

    private static PointerBase getJavaFrameAnchor() {
        CLongPointer currentThreadLastJavaPCOffset = (CLongPointer)WordFactory.unsigned((long)HotSpotJVMCIRuntime.runtime().getCurrentJavaThread()).add(LibGraalJNIMethodScope.getLastJavaPCOffset());
        return WordFactory.pointer((long)currentThreadLastJavaPCOffset.read());
    }

    private static int getLastJavaPCOffset() {
        int res = lastJavaPCOffset;
        if (res == -1) {
            HotSpotVMConfigAccess configAccess = new HotSpotVMConfigAccess(HotSpotJVMCIRuntime.runtime().getConfigStore());
            int anchor = (Integer)configAccess.getFieldOffset("JavaThread::_anchor", Integer.class, "JavaFrameAnchor");
            int lastJavaPc = (Integer)configAccess.getFieldOffset("JavaFrameAnchor::_last_Java_pc", Integer.class, "address");
            lastJavaPCOffset = res = anchor + lastJavaPc;
        }
        return res;
    }
}

