/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongPredicate;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class NativeIsolate {
    static final int CLOSED = -1;
    private static final long NULL = 0L;
    private static final Map<Long, NativeIsolate> isolates = new ConcurrentHashMap<Long, NativeIsolate>();
    private static final AtomicInteger UUIDS = new AtomicInteger(0);
    private final long uuid;
    private final long isolateId;
    private final JNIConfig config;
    private final Set<Cleaner> cleaners;
    private final ReferenceQueue<Object> cleanersQueue;
    private final ThreadLocal<NativeIsolateThread> attachedIsolateThread;
    private final Collection<NativeIsolateThread> threads;
    private volatile State state;

    private NativeIsolate(long isolateId, JNIConfig config) {
        if (isolateId == 0L) {
            throw new IllegalArgumentException("Isolate address must be non NULL");
        }
        this.uuid = UUIDS.incrementAndGet();
        this.isolateId = isolateId;
        this.config = config;
        this.cleaners = Collections.newSetFromMap(new ConcurrentHashMap());
        this.cleanersQueue = new ReferenceQueue();
        this.threads = new ArrayList<NativeIsolateThread>();
        this.attachedIsolateThread = new ThreadLocal();
        this.state = State.ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNativeThread(long isolateThreadId) {
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        if (nativeIsolateThread != null) {
            throw new IllegalStateException(String.format("Native thread %s is already attached to isolate %s.", Thread.currentThread(), this));
        }
        NativeIsolate nativeIsolate = this;
        synchronized (nativeIsolate) {
            if (!this.state.isValid()) {
                throw this.throwClosedException();
            }
            nativeIsolateThread = new NativeIsolateThread(Thread.currentThread(), this, true, isolateThreadId);
            this.threads.add(nativeIsolateThread);
            this.attachedIsolateThread.set(nativeIsolateThread);
        }
    }

    public NativeIsolateThread enter() {
        NativeIsolateThread nativeIsolateThread = this.getOrCreateNativeIsolateThread();
        nativeIsolateThread.enter();
        return nativeIsolateThread;
    }

    public boolean isActive() {
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        return nativeIsolateThread != null && (nativeIsolateThread.isNativeThread() || nativeIsolateThread.isActive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        boolean deferredClose = false;
        NativeIsolate nativeIsolate = this;
        synchronized (nativeIsolate) {
            if (this.state == State.DISPOSED) {
                return true;
            }
            this.state = State.DISPOSING;
            for (NativeIsolateThread nativeIsolateThread : this.threads) {
                deferredClose |= !nativeIsolateThread.invalidate();
            }
        }
        if (deferredClose) {
            return false;
        }
        return this.doIsolateShutdown();
    }

    public long getIsolateId() {
        return this.isolateId;
    }

    public JNIConfig getConfig() {
        return this.config;
    }

    public String toString() {
        return "NativeIsolate[" + this.uuid + " for 0x" + Long.toHexString(this.isolateId) + "]";
    }

    public static NativeIsolate get(long isolateId) {
        NativeIsolate res = isolates.get(isolateId);
        if (res == null) {
            throw new IllegalStateException("NativeIsolate for isolate 0x" + Long.toHexString(isolateId) + " does not exist.");
        }
        return res;
    }

    public static NativeIsolate forIsolateId(long isolateId, JNIConfig config) {
        NativeIsolate res = new NativeIsolate(isolateId, config);
        NativeIsolate previous = isolates.put(isolateId, res);
        if (previous != null && previous.state != State.DISPOSED) {
            throw new IllegalStateException("NativeIsolate for isolate 0x" + Long.toHexString(isolateId) + " already exists and is not disposed.");
        }
        return res;
    }

    public void registerForCleanup(Object cleanableObject, LongPredicate cleanupAction) {
        if (this.state != State.DISPOSED) {
            this.cleanHandles();
            this.cleaners.add(new Cleaner(this.cleanersQueue, cleanableObject, cleanupAction));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lastLeave() {
        NativeIsolate nativeIsolate = this;
        synchronized (nativeIsolate) {
            for (NativeIsolateThread nativeIsolateThread : this.threads) {
                if (!nativeIsolateThread.isActive()) continue;
                return;
            }
        }
        this.doIsolateShutdown();
    }

    RuntimeException throwClosedException() {
        throw new IllegalStateException("Isolate 0x" + Long.toHexString(this.getIsolateId()) + " is already closed.");
    }

    private void cleanHandles() {
        NativeIsolateThread nativeIsolateThread = null;
        try {
            Cleaner cleaner;
            while ((cleaner = (Cleaner)this.cleanersQueue.poll()) != null) {
                if (!this.cleaners.remove(cleaner)) continue;
                if (nativeIsolateThread == null) {
                    nativeIsolateThread = this.enter();
                }
                NativeIsolate.cleanImpl(this.isolateId, nativeIsolateThread.getIsolateThreadId(), cleaner.action);
            }
        }
        finally {
            if (nativeIsolateThread != null) {
                nativeIsolateThread.leave();
            }
        }
    }

    private static void cleanImpl(long isolate, long isolateThread, LongPredicate action) {
        block5: {
            try {
                if (!action.test(isolateThread)) {
                    throw new Exception(String.format("Error releasing %s in isolate 0x%x.", action, isolate));
                }
            }
            catch (Throwable t) {
                boolean ae = false;
                if (!$assertionsDisabled) {
                    ae = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (!ae) break block5;
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doIsolateShutdown() {
        NativeIsolate nativeIsolate2 = this;
        synchronized (nativeIsolate2) {
            if (this.state == State.DISPOSED) {
                return true;
            }
            this.state = State.DISPOSED;
        }
        this.cleaners.clear();
        boolean success = false;
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        if (nativeIsolateThread == null) {
            nativeIsolateThread = new NativeIsolateThread(Thread.currentThread(), this, false, this.config.attachThread(this.isolateId));
            nativeIsolateThread.invalidate();
            this.attachedIsolateThread.set(nativeIsolateThread);
        }
        try {
            nativeIsolateThread.setShutDownRequest(true);
            try {
                success = this.config.shutDownIsolate(this.isolateId, nativeIsolateThread.isolateThread);
            }
            finally {
                nativeIsolateThread.setShutDownRequest(false);
            }
        }
        finally {
            if (success) {
                isolates.computeIfPresent(this.isolateId, (id, nativeIsolate) -> nativeIsolate == this ? null : nativeIsolate);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeIsolateThread getOrCreateNativeIsolateThread() {
        NativeIsolateThread nativeIsolateThread = this.attachedIsolateThread.get();
        if (nativeIsolateThread == null) {
            NativeIsolate nativeIsolate = this;
            synchronized (nativeIsolate) {
                if (!this.state.isValid()) {
                    throw this.throwClosedException();
                }
                nativeIsolateThread = new NativeIsolateThread(Thread.currentThread(), this, false, this.config.attachThread(this.isolateId));
                this.threads.add(nativeIsolateThread);
                this.attachedIsolateThread.set(nativeIsolateThread);
            }
        }
        return nativeIsolateThread;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum State {
        ACTIVE(true),
        DISPOSING(false),
        DISPOSED(false);

        private final boolean valid;

        private State(boolean valid) {
            this.valid = valid;
        }

        boolean isValid() {
            return this.valid;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Cleaner
    extends WeakReference<Object> {
        private final LongPredicate action;

        private Cleaner(ReferenceQueue<Object> cleanersQueue, Object referent, LongPredicate action) {
            super(referent, cleanersQueue);
            this.action = action;
        }
    }
}

