/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongPredicate;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NativeObject {
    private final NativeIsolate isolate;
    private final long objectHandle;
    private final CleanupAction cleanupAction;

    public NativeObject(NativeIsolate isolate, long objectHandle) {
        this.isolate = isolate;
        this.objectHandle = objectHandle;
        this.cleanupAction = new CleanupAction(objectHandle, isolate.getConfig());
        isolate.registerForCleanup(this, this.cleanupAction);
    }

    public final NativeIsolate getIsolate() {
        return this.isolate;
    }

    public final long getHandle() {
        return this.objectHandle;
    }

    public final void release() {
        if (!this.cleanupAction.released.get()) {
            NativeIsolateThread nativeIsolateThread = this.isolate.enter();
            try {
                this.cleanupAction.test(nativeIsolateThread.getIsolateThreadId());
            }
            finally {
                nativeIsolateThread.leave();
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class CleanupAction
    implements LongPredicate {
        private final long handle;
        private final JNIConfig config;
        private final AtomicBoolean released;

        CleanupAction(long handle, JNIConfig config) {
            this.handle = handle;
            this.config = config;
            this.released = new AtomicBoolean();
        }

        @Override
        public boolean test(long isolateThread) {
            if (this.released.compareAndSet(false, true)) {
                return this.config.releaseNativeObject(isolateThread, this.handle);
            }
            return true;
        }

        public String toString() {
            return "NativeObject 0x" + Long.toHexString(this.handle);
        }
    }
}

