/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotManagement;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotSource;
import com.oracle.truffle.polyglot.PolyglotSourceSection;
import com.oracle.truffle.polyglot.PolyglotTargetMapping;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.proxy.Proxy;

public final class PolyglotImpl
extends AbstractPolyglotImpl {
    static final Object[] EMPTY_ARGS = new Object[0];
    private static final HostException STACKOVERFLOW_ERROR = new HostException(new StackOverflowError(){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    });
    private final PolyglotSource sourceImpl = new PolyglotSource(this);
    private final PolyglotSourceSection sourceSectionImpl = new PolyglotSourceSection(this);
    private final PolyglotManagement executionListenerImpl = new PolyglotManagement(this);
    private final AtomicReference<PolyglotEngineImpl> preInitializedEngineRef = new AtomicReference();
    final Map<Class<?>, PolyglotValue> primitiveValues = new HashMap();
    Value hostNull;
    PolyglotValue disconnectedHostValue;
    static volatile PolyglotImpl polyglotImpl;

    public PolyglotImpl() {
        assert (polyglotImpl == null) : "only one instance allowed";
        polyglotImpl = this;
    }

    static PolyglotImpl getInstance() {
        return polyglotImpl;
    }

    protected void initialize() {
        this.hostNull = this.getAPIAccess().newValue((Object)HostObject.NULL, (AbstractPolyglotImpl.AbstractValueImpl)PolyglotValue.createHostNull(this));
        PolyglotValue.createDefaultValues(this, null, this.primitiveValues);
        this.disconnectedHostValue = new PolyglotValue.HostValue(this);
    }

    public Context getLimitEventContext(Object impl) {
        return (Context)impl;
    }

    public Object buildLimits(long statementLimit, Predicate<org.graalvm.polyglot.Source> statementLimitSourceFilter, Duration timeLimit, Duration timeLimitAccuracy, Consumer<ResourceLimitEvent> onLimit) {
        try {
            return new PolyglotLimits(statementLimit, statementLimitSourceFilter, timeLimit, timeLimitAccuracy, onLimit);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public AbstractPolyglotImpl.AbstractSourceImpl getSourceImpl() {
        return this.sourceImpl;
    }

    public AbstractPolyglotImpl.AbstractSourceSectionImpl getSourceSectionImpl() {
        return this.sourceSectionImpl;
    }

    public AbstractPolyglotImpl.AbstractManagementImpl getManagementImpl() {
        return this.executionListenerImpl;
    }

    public Context getCurrentContext() {
        try {
            PolyglotContextImpl context = PolyglotContextImpl.currentNotEntered();
            if (context == null) {
                throw PolyglotEngineException.illegalState("No current context is available. Make sure the Java method is invoked by a Graal guest language or a context is entered using Context.enter().");
            }
            return context.currentApi;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> options, long timeout, TimeUnit timeoutUnit, boolean sandbox, long maximumAllowedAllocationBytes, boolean useSystemProperties, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandlerOrStream, HostAccess conf) {
        PolyglotEngineImpl impl = null;
        try {
            Engine engine;
            if (TruffleOptions.AOT) {
                EngineAccessor.ACCESSOR.initializeNativeImageTruffleLocator();
            }
            OutputStream resolvedOut = out == null ? System.out : out;
            OutputStream resolvedErr = err == null ? System.err : err;
            InputStream resolvedIn = in == null ? System.in : in;
            DispatchOutputStream dispatchOut = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedOut);
            DispatchOutputStream dispatchErr = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedErr);
            Handler logHandler = PolyglotLoggers.asHandler(logHandlerOrStream);
            logHandler = logHandler != null ? logHandler : PolyglotLoggers.createDefaultHandler(resolvedErr);
            ClassLoader contextClassLoader = TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader();
            PolyglotEngineImpl polyglotEngineImpl = impl = boundEngine ? (PolyglotEngineImpl)this.preInitializedEngineRef.getAndSet(null) : null;
            if (impl != null && !impl.patch(dispatchOut, dispatchErr, resolvedIn, options, useSystemProperties, allowExperimentalOptions, contextClassLoader, boundEngine, logHandler)) {
                impl.ensureClosed(false, true);
                impl = null;
            }
            if (impl == null) {
                impl = new PolyglotEngineImpl(this, dispatchOut, dispatchErr, resolvedIn, options, allowExperimentalOptions, useSystemProperties, contextClassLoader, boundEngine, messageInterceptor, logHandler);
            }
            impl.creatorApi = engine = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)impl);
            impl.currentApi = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)impl);
            return engine;
        }
        catch (Throwable t) {
            if (impl == null) {
                throw PolyglotImpl.guestToHostException(this, t);
            }
            throw PolyglotImpl.guestToHostException(impl, t);
        }
    }

    public void preInitializeEngine() {
        Handler logHandler = PolyglotLoggers.createStreamHandler(System.err, false, true);
        try {
            PolyglotEngineImpl preInitializedEngine = PolyglotEngineImpl.preInitialize(this, EngineAccessor.INSTRUMENT.createDispatchOutput(System.out), EngineAccessor.INSTRUMENT.createDispatchOutput(System.err), System.in, TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader(), logHandler);
            this.preInitializedEngineRef.set(preInitializedEngine);
        }
        finally {
            logHandler.flush();
        }
    }

    public void resetPreInitializedEngine() {
        this.preInitializedEngineRef.set(null);
        PolyglotEngineImpl.resetPreInitializedEngine();
    }

    public Class<?> loadLanguageClass(String className) {
        for (Supplier supplier : EngineAccessor.locatorOrDefaultLoaders()) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null) continue;
            try {
                Class<?> c = loader.loadClass(className);
                if (!TruffleOptions.AOT) {
                    EngineAccessor.JDKSERVICES.exportTo(loader, null);
                }
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public Collection<Engine> findActiveEngines() {
        return PolyglotEngineImpl.findActiveEngines();
    }

    public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue) {
        try {
            return new PolyglotTargetMapping(sourceType, targetType, acceptsValue, convertValue);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    Value asValue(PolyglotContextImpl currentContext, Object hostValue) {
        if (currentContext != null) {
            return currentContext.asValue(hostValue);
        }
        assert (!(hostValue instanceof Value));
        PolyglotContextImpl valueContext = null;
        Object guestValue = null;
        if (hostValue == null) {
            return this.hostNull;
        }
        if (PolyglotImpl.isGuestPrimitive(hostValue)) {
            return this.getAPIAccess().newValue(hostValue, (AbstractPolyglotImpl.AbstractValueImpl)this.primitiveValues.get(hostValue.getClass()));
        }
        if (HostWrapper.isInstance(hostValue)) {
            HostWrapper hostWrapper = HostWrapper.asInstance(hostValue);
            guestValue = hostWrapper.getGuestObject();
            valueContext = hostWrapper.getContext();
            return valueContext.asValue(guestValue);
        }
        guestValue = hostValue instanceof TruffleObject ? hostValue : (hostValue instanceof Proxy ? PolyglotProxy.toProxyGuestObject(null, (Proxy)hostValue) : (hostValue instanceof Class ? HostObject.forClass((Class)hostValue, null) : HostObject.forObject(hostValue, null)));
        return this.getAPIAccess().newValue(guestValue, (AbstractPolyglotImpl.AbstractValueImpl)this.disconnectedHostValue);
    }

    @CompilerDirectives.TruffleBoundary
    public Value asValue(Object hostValue) {
        try {
            PolyglotContextImpl currentContext = PolyglotContextImpl.currentNotEntered();
            return this.asValue(currentContext, hostValue);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public FileSystem newDefaultFileSystem() {
        return FileSystems.newDefaultFileSystem();
    }

    org.graalvm.polyglot.Source getPolyglotSource(Source source) {
        org.graalvm.polyglot.Source polyglotSource = EngineAccessor.SOURCE.getPolyglotSource(source);
        if (polyglotSource == null) {
            polyglotSource = this.getAPIAccess().newSource(source.getLanguage(), (Object)source);
            EngineAccessor.SOURCE.setPolyglotSource(source, polyglotSource);
        }
        return polyglotSource;
    }

    org.graalvm.polyglot.SourceSection getPolyglotSourceSection(SourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        org.graalvm.polyglot.Source polyglotSource = this.getPolyglotSource(sourceSection.getSource());
        return this.getAPIAccess().newSourceSection(polyglotSource, (Object)sourceSection);
    }

    static <T extends Throwable> RuntimeException hostToGuestException(PolyglotLanguageContext context, T e) {
        return PolyglotImpl.hostToGuestException(context.context, e);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException hostToGuestException(PolyglotContextImpl context, T e) {
        assert (!(e instanceof PolyglotEngineException)) : "engine exceptions not expected here";
        assert (!(e instanceof HostException)) : "host exceptions not expected here";
        if (e instanceof ThreadDeath) {
            throw (ThreadDeath)e;
        }
        if (e instanceof PolyglotException) {
            PolyglotException polyglot = (PolyglotException)e;
            if (context != null) {
                PolyglotExceptionImpl exceptionImpl = (PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl(polyglot);
                if (exceptionImpl.context == context || exceptionImpl.context == null || exceptionImpl.isHostException()) {
                    Throwable original = ((PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl((PolyglotException)polyglot)).exception;
                    if (original instanceof RuntimeException) {
                        throw (RuntimeException)original;
                    }
                    if (original instanceof Error) {
                        throw (Error)original;
                    }
                }
            }
        }
        try {
            return new HostException(e);
        }
        catch (StackOverflowError stack) {
            return STACKOVERFLOW_ERROR;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToLanguageException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest language";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToInstrumentException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest instrument";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException guestToHostException(PolyglotLanguageContext languageContext, T e) {
        PolyglotExceptionImpl exceptionImpl;
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host";
        PolyglotEngineException.rethrow(e);
        if (languageContext == null) {
            throw new RuntimeException(e);
        }
        PolyglotContextImpl context = languageContext.context;
        if (context.closed || context.invalid) {
            exceptionImpl = new PolyglotExceptionImpl(context.engine, e);
        } else {
            try {
                Object prev = context.engine.enterIfNeeded(context);
                try {
                    exceptionImpl = new PolyglotExceptionImpl(languageContext, e);
                }
                finally {
                    context.engine.leaveIfNeeded(prev, context);
                }
            }
            catch (Throwable t) {
                e.addSuppressed(t);
                exceptionImpl = new PolyglotExceptionImpl(context.engine, e);
            }
        }
        AbstractPolyglotImpl.APIAccess access = PolyglotImpl.getInstance().getAPIAccess();
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionImpl)exceptionImpl);
    }

    static <T extends Throwable> PolyglotException guestToHostException(PolyglotEngineImpl engine, T e) {
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host";
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = engine.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(engine, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionImpl)exceptionImpl);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException guestToHostException(PolyglotImpl polyglot, T e) {
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host";
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = polyglot.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(polyglot, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionImpl)exceptionImpl);
    }

    static boolean isGuestPrimitive(Object receiver) {
        return receiver instanceof Integer || receiver instanceof Double || receiver instanceof Long || receiver instanceof Float || receiver instanceof Boolean || receiver instanceof Character || receiver instanceof Byte || receiver instanceof Short || receiver instanceof String;
    }

    static interface VMObject {
        public PolyglotEngineImpl getEngine();

        default public PolyglotImpl getImpl() {
            return this.getEngine().impl;
        }

        default public AbstractPolyglotImpl.APIAccess getAPIAccess() {
            return this.getEngine().impl.getAPIAccess();
        }
    }
}

