/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.generate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SectionIdGenerator {
    private Map<Integer, AtomicInteger> levelCounters = new HashMap<Integer, AtomicInteger>(5);

    public String nextId(int level) {
        if (!this.levelCounters.containsKey(level)) {
            this.levelCounters.put(level, new AtomicInteger(0));
        }
        int lastValue = this.levelCounters.get(level).incrementAndGet();
        StringBuilder id = new StringBuilder();
        for (String parentValue : this.getParentValues(level)) {
            id.append(parentValue);
            id.append(".");
        }
        id.append(lastValue);
        this.resetChildValues(level);
        return id.toString();
    }

    public void reset() {
        this.levelCounters.clear();
    }

    private List<String> getParentValues(int level) {
        ArrayList<String> parts = new ArrayList<String>();
        for (Map.Entry<Integer, AtomicInteger> counter : this.levelCounters.entrySet()) {
            if (counter.getKey() >= level) continue;
            parts.add(counter.getValue().toString());
        }
        return parts;
    }

    private void resetChildValues(int level) {
        for (Map.Entry<Integer, AtomicInteger> counter : this.levelCounters.entrySet()) {
            if (counter.getKey() <= level) continue;
            counter.getValue().set(0);
        }
    }
}

