/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.jboss.test.audit.config.RuntimeProperties;
import org.jboss.test.audit.report.AuditParser;
import org.jboss.test.audit.report.CoverageReport;
import org.jboss.test.audit.report.SpecReference;

@SupportedAnnotationTypes(value={"org.jboss.test.audit.annotations.SpecAssertion", "org.jboss.test.audit.annotations.SpecAssertions"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"outputDir", "auditXml"})
public class CoverageProcessor
extends AbstractProcessor {
    protected static final String OUTDIR_OPTION_FLAG = "outputDir";
    protected static final String AUDITFILE_OPTION_KEY = "auditXml";
    private static final String DEFAULT_AUDIT_FILE_NAME = "test-audit.xml";
    private final RuntimeProperties properties = new RuntimeProperties();
    private final Map<String, List<SpecReference>> references = new HashMap<String, List<SpecReference>>();
    private Map<String, AuditParser> auditParsers;
    private File baseDir;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.createOutputDirs();
        File[] auditFiles = this.getAuditFiles();
        this.auditParsers = new HashMap<String, AuditParser>();
        for (File f : auditFiles) {
            InputStream in = this.getAuditFileInputStream(f);
            if (in == null) {
                return;
            }
            AuditParser auditParser = null;
            try {
                auditParser = new AuditParser(in, this.properties);
                auditParser.parse();
                this.auditParsers.put(auditParser.getSpecId(), auditParser);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to parse audit file.", e);
            }
        }
    }

    private InputStream getAuditFileInputStream(File file) {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (IOException ex) {
            System.err.println("Unable to open audit file - " + file.getAbsolutePath());
            System.err.println("No report generated");
            return null;
        }
        return in;
    }

    private File[] getAuditFiles() {
        String auditFileNames = this.processingEnv.getOptions().get(AUDITFILE_OPTION_KEY);
        if (auditFileNames == null || auditFileNames.length() == 0) {
            auditFileNames = this.getCurrentWorkingDirectory() + DEFAULT_AUDIT_FILE_NAME;
            System.out.println("No audit file specified. Trying default: " + auditFileNames);
        } else {
            System.out.println("Reading spec assertions from audit file/s: " + auditFileNames);
        }
        String[] parts = auditFileNames.split(",");
        File[] files = new File[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            files[i] = new File(parts[i]);
        }
        return files;
    }

    private File getImagesDir() {
        return new File(this.getAuditFiles()[0].getParentFile(), "/images");
    }

    private void createOutputDirs() {
        String baseDirName = this.processingEnv.getOptions().get(OUTDIR_OPTION_FLAG);
        if (baseDirName == null) {
            baseDirName = this.getCurrentWorkingDirectory() + "target";
            System.out.println("No output directory specified, using " + baseDirName + " instead.");
        } else {
            System.out.println("Outputting to " + baseDirName);
        }
        this.baseDir = new File(baseDirName);
        this.baseDir.mkdirs();
    }

    private String getCurrentWorkingDirectory() {
        return System.getProperty("user.dir") + System.getProperty("file.separator");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (this.auditParsers.isEmpty()) {
            return false;
        }
        for (TypeElement typeElement : annotations) {
            this.processAnnotatedMethods(roundEnvironment, typeElement);
        }
        if (roundEnvironment.processingOver()) {
            for (AuditParser auditParser : this.auditParsers.values()) {
                try {
                    new CoverageReport(this.references.get(auditParser.getSpecId()), auditParser, this.getImagesDir(), this.properties).generateToOutputDir(this.baseDir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    private void processAnnotatedMethods(RoundEnvironment env, TypeElement annotation) {
        Set<? extends Element> elements = env.getElementsAnnotatedWith(annotation);
        for (Element element : elements) {
            this.processMethod(element);
        }
    }

    private void processMethod(Element element) {
        ExecutableElement methodElement = (ExecutableElement)element;
        String annotationType = null;
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(methodElement)) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParameters = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
            annotationType = annotationMirror.getAnnotationType().toString();
            if (annotationType.equals(SpecAssertions.class.getName())) {
                List mirrors = (List)annotationMirror.getElementValues().values().iterator().next().getValue();
                for (AnnotationMirror mirror : mirrors) {
                    this.createSpecReference(methodElement, this.processingEnv.getElementUtils().getElementValuesWithDefaults(mirror));
                }
                continue;
            }
            if (!annotationType.equals(SpecAssertion.class.getName())) continue;
            this.createSpecReference(methodElement, annotationParameters);
        }
    }

    private void createSpecReference(ExecutableElement methodElement, Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParameters) {
        SpecReference ref = new SpecReference();
        PackageElement packageElement = this.getEnclosingPackageElement(methodElement);
        ref.setPackageName(packageElement.getQualifiedName().toString());
        ref.setClassName(methodElement.getEnclosingElement().getSimpleName().toString());
        ref.setMethodName(methodElement.getSimpleName().toString());
        if (methodElement.getEnclosingElement().getAnnotation(SpecVersion.class) != null) {
            ref.setSpecId(methodElement.getEnclosingElement().getAnnotation(SpecVersion.class).spec());
            ref.setSpecVersion(methodElement.getEnclosingElement().getAnnotation(SpecVersion.class).version());
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParameters.entrySet()) {
            String elementKey = entry.getKey().toString();
            if (elementKey.equals("section()")) {
                ref.setSection((String)entry.getValue().getValue());
                continue;
            }
            if (!elementKey.equals("id()")) continue;
            ref.setAssertion((String)entry.getValue().getValue());
        }
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(methodElement)) {
            if (!annotationMirror.getAnnotationType().toString().equals("org.testng.annotations.Test")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> testAnnotationParameters = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : testAnnotationParameters.entrySet()) {
                String elementKey = entry.getKey().toString();
                if (!elementKey.equals("groups()")) continue;
                for (AnnotationValue annotationValue : (List)entry.getValue().getValue()) {
                    ref.getGroups().add((String)annotationValue.getValue());
                }
            }
        }
        List<SpecReference> refs = this.references.get(ref.getSpecId());
        if (refs == null) {
            refs = new ArrayList<SpecReference>();
            this.references.put(ref.getSpecId(), refs);
        }
        refs.add(ref);
    }

    private PackageElement getEnclosingPackageElement(ExecutableElement methodElement) {
        Element enclosingElement;
        Element classElement = methodElement.getEnclosingElement();
        for (enclosingElement = classElement.getEnclosingElement(); !(enclosingElement instanceof PackageElement) && enclosingElement != null; enclosingElement = enclosingElement.getEnclosingElement()) {
        }
        return (PackageElement)enclosingElement;
    }
}

