/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SpecReference {
    public static final Comparator<SpecReference> COMPARATOR = new SpecReferenceComparator();
    private String specId;
    private String specVersion;
    private String section;
    private String assertion;
    private String packageName;
    private String className;
    private String methodName;
    private List<String> groups = new ArrayList<String>();

    public void setSpecId(String specId) {
        this.specId = specId;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public void setAssertion(String assertion) {
        this.assertion = assertion;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getSpecId() {
        return this.specId;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getSection() {
        return this.section;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String toString() {
        return "SpecReference[version=" + this.specVersion + ";section=" + this.section + ";assertion=" + this.assertion + ";class=" + this.packageName + "." + this.className + ";method=" + this.methodName + "]";
    }

    public String getFqn() {
        return this.packageName + "." + this.className + "." + this.methodName;
    }

    private static class SpecReferenceComparator
    implements Comparator<SpecReference> {
        private SpecReferenceComparator() {
        }

        @Override
        public int compare(SpecReference arg0, SpecReference arg1) {
            return arg0.getFqn().compareToIgnoreCase(arg1.getFqn());
        }
    }
}

