/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BaseExecutor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoader;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class ResultLoaderMap {
    private final Map<String, LoadPair> loaderMap = new HashMap<String, LoadPair>();

    public void addLoader(String property, MetaObject metaResultObject, ResultLoader resultLoader) {
        String upperFirst = ResultLoaderMap.getUppercaseFirstProperty(property);
        if (!upperFirst.equalsIgnoreCase(property) && this.loaderMap.containsKey(upperFirst)) {
            throw new ExecutorException("Nested lazy loaded result property '" + property + "' for query id '" + resultLoader.mappedStatement.getId() + " already exists in the result map. The leftmost property of all lazy loaded properties must be unique within a result map.");
        }
        this.loaderMap.put(upperFirst, new LoadPair(property, metaResultObject, resultLoader));
    }

    public final Map<String, LoadPair> getProperties() {
        return new HashMap<String, LoadPair>(this.loaderMap);
    }

    public Set<String> getPropertyNames() {
        return this.loaderMap.keySet();
    }

    public int size() {
        return this.loaderMap.size();
    }

    public boolean hasLoader(String property) {
        return this.loaderMap.containsKey(property.toUpperCase(Locale.ENGLISH));
    }

    public boolean load(String property) throws SQLException {
        LoadPair pair = this.loaderMap.remove(property.toUpperCase(Locale.ENGLISH));
        if (pair != null) {
            pair.load();
            return true;
        }
        return false;
    }

    public void remove(String property) {
        this.loaderMap.remove(property.toUpperCase(Locale.ENGLISH));
    }

    public void loadAll() throws SQLException {
        String[] methodNames;
        Set<String> methodNameSet = this.loaderMap.keySet();
        for (String methodName : methodNames = methodNameSet.toArray(new String[methodNameSet.size()])) {
            this.load(methodName);
        }
    }

    private static String getUppercaseFirstProperty(String property) {
        String[] parts = property.split("\\.");
        return parts[0].toUpperCase(Locale.ENGLISH);
    }

    public static class LoadPair
    implements Serializable {
        private static final long serialVersionUID = 20130412L;
        private static final String FACTORY_METHOD = "getConfiguration";
        private final transient Object serializationCheck = new Object();
        private transient MetaObject metaResultObject;
        private transient ResultLoader resultLoader;
        private transient Log log;
        private Class<?> configurationFactory;
        private String property;
        private String mappedStatement;
        private Serializable mappedParameter;

        private LoadPair(String property, MetaObject metaResultObject, ResultLoader resultLoader) {
            this.property = property;
            this.metaResultObject = metaResultObject;
            this.resultLoader = resultLoader;
            if (metaResultObject != null && metaResultObject.getOriginalObject() instanceof Serializable) {
                Object mappedStatementParameter = resultLoader.parameterObject;
                if (mappedStatementParameter instanceof Serializable) {
                    this.mappedStatement = resultLoader.mappedStatement.getId();
                    this.mappedParameter = (Serializable)mappedStatementParameter;
                    this.configurationFactory = resultLoader.configuration.getConfigurationFactory();
                } else {
                    Log log = this.getLogger();
                    if (log.isDebugEnabled()) {
                        log.debug("Property [" + this.property + "] of [" + metaResultObject.getOriginalObject().getClass() + "] cannot be loaded after deserialization. Make sure it's loaded before serializing forenamed object.");
                    }
                }
            }
        }

        public void load() throws SQLException {
            if (this.metaResultObject == null) {
                throw new IllegalArgumentException("metaResultObject is null");
            }
            if (this.resultLoader == null) {
                throw new IllegalArgumentException("resultLoader is null");
            }
            this.load(null);
        }

        public void load(Object userObject) throws SQLException {
            if (this.metaResultObject == null || this.resultLoader == null) {
                if (this.mappedParameter == null) {
                    throw new ExecutorException("Property [" + this.property + "] cannot be loaded because required parameter of mapped statement [" + this.mappedStatement + "] is not serializable.");
                }
                Configuration config = this.getConfiguration();
                MappedStatement ms = config.getMappedStatement(this.mappedStatement);
                if (ms == null) {
                    throw new ExecutorException("Cannot lazy load property [" + this.property + "] of deserialized object [" + userObject.getClass() + "] because configuration does not contain statement [" + this.mappedStatement + "]");
                }
                this.metaResultObject = config.newMetaObject(userObject);
                this.resultLoader = new ResultLoader(config, new ClosedExecutor(), ms, this.mappedParameter, this.metaResultObject.getSetterType(this.property), null, null);
            }
            if (this.serializationCheck == null) {
                ResultLoader old = this.resultLoader;
                this.resultLoader = new ResultLoader(old.configuration, new ClosedExecutor(), old.mappedStatement, old.parameterObject, old.targetType, old.cacheKey, old.boundSql);
            }
            this.metaResultObject.setValue(this.property, this.resultLoader.loadResult());
        }

        private Configuration getConfiguration() {
            Object configurationObject;
            if (this.configurationFactory == null) {
                throw new ExecutorException("Cannot get Configuration as configuration factory was not set.");
            }
            try {
                Method factoryMethod = this.configurationFactory.getDeclaredMethod(FACTORY_METHOD, new Class[0]);
                if (!Modifier.isStatic(factoryMethod.getModifiers())) {
                    throw new ExecutorException("Cannot get Configuration as factory method [" + this.configurationFactory + "]#[" + FACTORY_METHOD + "] is not static.");
                }
                configurationObject = !factoryMethod.isAccessible() ? AccessController.doPrivileged(() -> {
                    try {
                        factoryMethod.setAccessible(true);
                        Object object = factoryMethod.invoke(null, new Object[0]);
                        return object;
                    }
                    finally {
                        factoryMethod.setAccessible(false);
                    }
                }) : factoryMethod.invoke(null, new Object[0]);
            }
            catch (ExecutorException ex) {
                throw ex;
            }
            catch (NoSuchMethodException ex) {
                throw new ExecutorException("Cannot get Configuration as factory class [" + this.configurationFactory + "] is missing factory method of name [" + FACTORY_METHOD + "].", ex);
            }
            catch (PrivilegedActionException ex) {
                throw new ExecutorException("Cannot get Configuration as factory method [" + this.configurationFactory + "]#[" + FACTORY_METHOD + "] threw an exception.", ex.getCause());
            }
            catch (Exception ex) {
                throw new ExecutorException("Cannot get Configuration as factory method [" + this.configurationFactory + "]#[" + FACTORY_METHOD + "] threw an exception.", ex);
            }
            if (!(configurationObject instanceof Configuration)) {
                throw new ExecutorException("Cannot get Configuration as factory method [" + this.configurationFactory + "]#[" + FACTORY_METHOD + "] didn't return [" + Configuration.class + "] but [" + (configurationObject == null ? "null" : configurationObject.getClass()) + "].");
            }
            return (Configuration)Configuration.class.cast(configurationObject);
        }

        private Log getLogger() {
            if (this.log == null) {
                this.log = LogFactory.getLog(this.getClass());
            }
            return this.log;
        }
    }

    private static final class ClosedExecutor
    extends BaseExecutor {
        public ClosedExecutor() {
            super(null, null);
        }

        @Override
        public boolean isClosed() {
            return true;
        }

        @Override
        protected int doUpdate(MappedStatement ms, Object parameter) throws SQLException {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        protected List<BatchResult> doFlushStatements(boolean isRollback) throws SQLException {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        protected <E> List<E> doQuery(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        protected <E> Cursor<E> doQueryCursor(MappedStatement ms, Object parameter, RowBounds rowBounds, BoundSql boundSql) throws SQLException {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

