/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ResolverUtil<T> {
    private static final Log log = LogFactory.getLog(ResolverUtil.class);
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public ResolverUtil<T> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> find(Test test, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            List<String> children = VFS.getInstance().list(path);
            for (String child : children) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(test, child);
            }
        }
        catch (IOException ioe) {
            log.error("Could not read package: " + packageName, ioe);
        }
        return this;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            Class<?> type;
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug("Checking to see if class " + externalName + " matches criteria [" + test + "]");
            }
            if (test.matches(type = loader.loadClass(externalName))) {
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            log.warn("Could not examine class '" + fqn + "' due to a " + t.getClass().getName() + " with message: " + t.getMessage());
        }
    }

    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    public static interface Test {
        public boolean matches(Class<?> var1);
    }

    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }
}

