/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.guava.cache;

import java.util.concurrent.Executor;
import org.nd4j.shade.guava.annotations.GwtIncompatible;
import org.nd4j.shade.guava.base.Preconditions;
import org.nd4j.shade.guava.cache.RemovalListener;
import org.nd4j.shade.guava.cache.RemovalNotification;

@GwtIncompatible
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

