/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.neo4j.ogm.config.Configuration;

final class ConfigurationUtils {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";

    static InputStream getResourceAsStream(String name) {
        String path = name;
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            path = path.substring(CLASSPATH_URL_PREFIX.length());
        }
        return Configuration.getDefaultClassLoader().getResourceAsStream(ConfigurationUtils.createRelativePathIfNecessary(path));
    }

    static URL getResourceUrl(String resourceLocation) throws FileNotFoundException {
        URL resourceUrl;
        Objects.requireNonNull(resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            resourceUrl = ConfigurationUtils.getClasspathResourceUrl(resourceLocation.substring(CLASSPATH_URL_PREFIX.length()));
        } else {
            try {
                resourceUrl = new URL(resourceLocation);
            }
            catch (MalformedURLException e) {
                resourceUrl = ConfigurationUtils.getClasspathResourceUrl(resourceLocation);
            }
        }
        return resourceUrl;
    }

    private static URL getClasspathResourceUrl(String path) throws FileNotFoundException {
        String pathToUse = ConfigurationUtils.createRelativePathIfNecessary(path);
        URL url = Configuration.getDefaultClassLoader().getResource(pathToUse);
        if (url == null) {
            String description = "class path resource [" + path + "]";
            throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    private static String createRelativePathIfNecessary(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private ConfigurationUtils() {
    }
}

