/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.builders.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.ogm.compiler.CypherStatementBuilder;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class DeletedRelationshipEntityStatementBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Edge> deletedEdges;

    public DeletedRelationshipEntityStatementBuilder(Set<Edge> deletedEdges, StatementFactory statementFactory) {
        this.deletedEdges = deletedEdges;
        this.statementFactory = statementFactory;
    }

    public Statement build() {
        HashMap parameters = new HashMap();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.deletedEdges != null && this.deletedEdges.size() > 0) {
            queryBuilder.append("START r=rel({relIds}) DELETE r");
            ArrayList<Long> relIds = new ArrayList<Long>(this.deletedEdges.size());
            ArrayList rows = new ArrayList();
            for (Edge edge : this.deletedEdges) {
                HashMap<String, Long> rowMap = new HashMap<String, Long>();
                rowMap.put("relId", edge.getId());
                rows.add(rowMap);
                relIds.add(edge.getId());
            }
            parameters.put("rows", rows);
            parameters.put("relIds", relIds);
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

