/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entity.io;

import java.lang.reflect.Field;
import org.neo4j.ogm.entity.io.EntityAccess;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.utils.ClassUtils;

public class FieldWriter
extends EntityAccess {
    private final FieldInfo fieldInfo;
    private final Field field;
    private final Class<?> fieldType;

    public FieldWriter(ClassInfo classInfo, FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.field = classInfo.getField(fieldInfo);
        this.fieldType = this.field.getType();
    }

    public static void write(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object read(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Object instance, Object value) {
        if (this.fieldInfo.hasPropertyConverter()) {
            value = this.fieldInfo.getPropertyConverter().toEntityAttribute(value);
            FieldWriter.write(this.field, instance, value);
        } else {
            if (this.fieldInfo.isScalar()) {
                String descriptor = this.fieldInfo.getTypeDescriptor();
                value = Utils.coerceTypes(ClassUtils.getType(descriptor), value);
            }
            FieldWriter.write(this.field, instance, value);
        }
    }

    @Override
    public Class<?> type() {
        Class<?> convertedType = this.fieldInfo.convertedType();
        if (convertedType != null) {
            return convertedType;
        }
        return this.fieldType;
    }

    @Override
    public String relationshipName() {
        return this.fieldInfo.relationship();
    }

    @Override
    public String relationshipDirection() {
        return this.fieldInfo.relationshipDirection("UNDIRECTED");
    }

    @Override
    public boolean forScalar() {
        return !Iterable.class.isAssignableFrom(this.type()) && !this.type().isArray();
    }

    @Override
    public String typeParameterDescriptor() {
        return this.fieldInfo.getTypeDescriptor();
    }
}

