/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.entity.io.EntityAccessManager;
import org.neo4j.ogm.entity.io.FieldReader;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class LoadByIdsDelegate
implements Capability.LoadByIds {
    private final Neo4jSession session;

    public LoadByIdsDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, Pagination pagination, int depth) {
        Collection<String> entityType = this.session.metaData().classInfo(type.getName()).types();
        QueryStatements<ID> queryStatements = this.session.queryStatementsFor(type);
        PagingAndSortingQuery qry = queryStatements.findAllByType(entityType, ids, depth).setSortOrder(sortOrder).setPagination(pagination);
        try (Response response = this.session.requestHandler().execute((GraphModelRequest)qry);){
            Iterable<T> mapped = new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
            LinkedHashSet<T> results = new LinkedHashSet<T>();
            for (T entity : mapped) {
                if (!this.includeMappedEntity(ids, entity)) continue;
                results.add(entity);
            }
            LinkedHashSet<T> linkedHashSet = results;
            return linkedHashSet;
        }
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids) {
        return this.loadAll(type, ids, new SortOrder(), null, 1);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, int depth) {
        return this.loadAll(type, ids, new SortOrder(), null, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder) {
        return this.loadAll(type, ids, sortOrder, null, 1);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, int depth) {
        return this.loadAll(type, ids, sortOrder, null, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, Pagination paging) {
        return this.loadAll(type, ids, new SortOrder(), paging, 1);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, Pagination paging, int depth) {
        return this.loadAll(type, ids, new SortOrder(), paging, depth);
    }

    @Override
    public <T, ID extends Serializable> Collection<T> loadAll(Class<T> type, Collection<ID> ids, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, ids, sortOrder, pagination, 1);
    }

    private <T, ID extends Serializable> boolean includeMappedEntity(Collection<ID> ids, T mapped) {
        Object primaryIndexValue;
        ClassInfo classInfo = this.session.metaData().classInfo(mapped);
        FieldInfo primaryIndexField = classInfo.primaryIndexField();
        if (primaryIndexField != null && ids.contains(primaryIndexValue = new FieldReader(classInfo, primaryIndexField).read(mapped))) {
            return true;
        }
        Object id = EntityAccessManager.getIdentityPropertyReader(classInfo).readProperty(mapped);
        return ids.contains(id);
    }
}

