/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.Serializable;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jException;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class LoadOneDelegate
implements Capability.LoadOne {
    private Neo4jSession session;

    public LoadOneDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T, ID extends Serializable> T load(Class<T> type, ID id) {
        return this.load(type, id, 1);
    }

    @Override
    public <T, ID extends Serializable> T load(Class<T> type, ID id, int depth) {
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        if (classInfo == null) {
            throw new IllegalArgumentException(type + " is not a managed entity.");
        }
        FieldInfo primaryIndexField = classInfo.primaryIndexField();
        if (primaryIndexField != null && !primaryIndexField.isTypeOf(id.getClass())) {
            throw new Neo4jException("Supplied id does not match primary index type on supplied class.");
        }
        QueryStatements<ID> queryStatements = this.session.queryStatementsFor(type);
        PagingAndSortingQuery qry = queryStatements.findOneByType(classInfo.types(), id, depth);
        try (Response response = this.session.requestHandler().execute((GraphModelRequest)qry);){
            new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
            T t = this.lookup(type, id);
            return t;
        }
    }

    private <T, U> T lookup(Class<T> type, U id) {
        ClassInfo typeInfo = this.session.metaData().classInfo(type.getName());
        Object ref = typeInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null ? this.session.context().getNodeEntity(id) : this.session.context().getRelationshipEntity((Long)id);
        try {
            return type.cast(ref);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }
}

