/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.context.DirectedRelationship;
import org.neo4j.ogm.context.DirectedRelationshipForType;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DescriptorMappings;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.support.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAccessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityAccessManager.class);
    private static Map<ClassInfo, Map<DirectedRelationship, FieldInfo>> relationalReaderCache = new ConcurrentHashMap<ClassInfo, Map<DirectedRelationship, FieldInfo>>();
    private static Map<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>> relationalWriterCache = new ConcurrentHashMap<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>>();
    private static Map<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>> iterableWriterCache = new ConcurrentHashMap<ClassInfo, Map<DirectedRelationshipForType, FieldInfo>>();
    private static final boolean STRICT_MODE = true;
    private static final boolean INFERRED_MODE = false;

    public static Object merge(Class<?> parameterType, Object newValues, Object[] currentValues, Class elementType) {
        if (currentValues != null) {
            return EntityAccessManager.merge(parameterType, newValues, Arrays.asList(currentValues), elementType);
        }
        return EntityAccessManager.merge(parameterType, newValues, new ArrayList(), elementType);
    }

    public static Object merge(Class<?> parameterType, Object newValues, Collection currentValues, Class elementType) {
        if (newValues != null) {
            newValues = EntityAccessManager.boxPrimitiveArray(newValues);
            newValues = EntityAccessManager.stringToCharacterIterable(newValues, parameterType, elementType);
        }
        if (parameterType.isArray()) {
            Class<?> componentType = parameterType.getComponentType();
            Collection<Object> mergedValues = EntityAccessManager.mergeAndCoerce(componentType, (Collection)newValues, currentValues);
            Object targetArray = Array.newInstance(componentType, mergedValues.size());
            AtomicInteger cnt = new AtomicInteger(0);
            mergedValues.forEach(object -> Array.set(targetArray, cnt.getAndIncrement(), object));
            return targetArray;
        }
        Collection<?> newCollection = EntityAccessManager.createTargetCollection(parameterType, EntityAccessManager.mergeAndCoerce(elementType, (Collection)newValues, currentValues));
        if (newCollection != null) {
            return newCollection;
        }
        if (newValues != null && parameterType.isAssignableFrom(newValues.getClass())) {
            return newValues;
        }
        throw new RuntimeException("Unsupported: " + parameterType.getName());
    }

    private static Collection<Object> mergeAndCoerce(Class elementType, Collection left, Collection right) {
        Collection<Object> coercedLeft = EntityAccessManager.coerceCollection(elementType, left);
        Collection<Object> coercedRight = EntityAccessManager.coerceCollection(elementType, right);
        coercedRight.removeAll(coercedLeft);
        ArrayList<Object> result = new ArrayList<Object>(coercedLeft.size() + coercedRight.size());
        result.addAll(coercedRight);
        result.addAll(coercedLeft);
        return result;
    }

    private static Collection<Object> coerceCollection(Class<Object> targetType, Collection<Object> source) {
        List<Object> target;
        if (source == null || source.isEmpty()) {
            target = Collections.emptyList();
        } else {
            target = new ArrayList<Object>(source.size());
            for (Object object : source) {
                target.add(Utils.coerceTypes(targetType, object));
            }
        }
        return target;
    }

    private static Collection<?> createTargetCollection(Class<?> parameterType, Collection collection) {
        if (Vector.class.isAssignableFrom(parameterType)) {
            return collection instanceof Vector ? collection : new Vector(collection);
        }
        if (List.class.isAssignableFrom(parameterType)) {
            return collection instanceof ArrayList ? collection : new ArrayList(collection);
        }
        if (SortedSet.class.isAssignableFrom(parameterType)) {
            return collection instanceof TreeSet ? collection : new TreeSet(collection);
        }
        if (Set.class.isAssignableFrom(parameterType)) {
            return collection instanceof HashSet ? collection : new HashSet(collection);
        }
        return null;
    }

    private static Object stringToCharacterIterable(Object value, Class parameterType, Class elementType) {
        boolean convertCharacters = false;
        if (value instanceof String) {
            char[] chars = ((String)value).toCharArray();
            ArrayList<Character> characters = new ArrayList<Character>(chars.length);
            for (char c : chars) {
                characters.add(Character.valueOf(c));
            }
            return characters;
        }
        if (parameterType.getComponentType() != null) {
            if (parameterType.getComponentType().equals(Character.class)) {
                convertCharacters = true;
            }
        } else if (elementType == Character.class || elementType == Character.TYPE) {
            convertCharacters = true;
        }
        if (value.getClass().isArray() && convertCharacters && value.getClass().getComponentType().equals(String.class)) {
            String[] strings = (String[])value;
            ArrayList<Character> characters = new ArrayList<Character>(strings.length);
            for (String s : strings) {
                characters.add(Character.valueOf(s.toCharArray()[0]));
            }
            return characters;
        }
        if (value.getClass().isArray() && (elementType == String.class || ClassUtils.isEnum((Class)elementType))) {
            String[] strings = (String[])value;
            return Arrays.asList(strings);
        }
        return value;
    }

    private static Object boxPrimitiveArray(Object value) {
        if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            switch (value.getClass().getComponentType().toString()) {
                case "int": {
                    int[] intArray = (int[])value;
                    ArrayList<Integer> boxedIntList = new ArrayList<Integer>(intArray.length);
                    for (int i : intArray) {
                        boxedIntList.add(i);
                    }
                    return boxedIntList;
                }
                case "float": {
                    float[] floatArray = (float[])value;
                    ArrayList<Float> boxedFloatList = new ArrayList<Float>(floatArray.length);
                    for (float f : floatArray) {
                        boxedFloatList.add(Float.valueOf(f));
                    }
                    return boxedFloatList;
                }
                case "long": {
                    long[] longArray = (long[])value;
                    ArrayList<Long> boxedLongList = new ArrayList<Long>(longArray.length);
                    for (long l : longArray) {
                        boxedLongList.add(l);
                    }
                    return boxedLongList;
                }
                case "double": {
                    double[] dblArray = (double[])value;
                    ArrayList<Double> boxedDoubleList = new ArrayList<Double>(dblArray.length);
                    for (double d : dblArray) {
                        boxedDoubleList.add(d);
                    }
                    return boxedDoubleList;
                }
                case "boolean": {
                    boolean[] booleanArray = (boolean[])value;
                    ArrayList<Boolean> boxedBooleanList = new ArrayList<Boolean>(booleanArray.length);
                    for (boolean b : booleanArray) {
                        boxedBooleanList.add(b);
                    }
                    return boxedBooleanList;
                }
                case "char": {
                    char[] charArray = (char[])value;
                    ArrayList<Character> boxedCharList = new ArrayList<Character>(charArray.length);
                    for (char c : charArray) {
                        boxedCharList.add(Character.valueOf(c));
                    }
                    return boxedCharList;
                }
            }
        }
        return value;
    }

    public static FieldInfo getRelationalWriter(ClassInfo classInfo, String relationshipType, String relationshipDirection, Object scalarValue) {
        return EntityAccessManager.getRelationalWriter(classInfo, relationshipType, relationshipDirection, scalarValue.getClass());
    }

    public static FieldInfo getRelationalWriter(ClassInfo classInfo, String relationshipType, String relationshipDirection, Class<?> objectType) {
        DirectedRelationshipForType directedRelationship = new DirectedRelationshipForType(relationshipType, relationshipDirection, objectType);
        Map typeFieldInfoMap = relationalWriterCache.computeIfAbsent(classInfo, key -> new ConcurrentHashMap());
        if (typeFieldInfoMap.containsKey(directedRelationship)) {
            return (FieldInfo)typeFieldInfoMap.get(directedRelationship);
        }
        while (classInfo != null) {
            for (FieldInfo fieldInfo : classInfo.candidateRelationshipFields(relationshipType, relationshipDirection, true)) {
                if (fieldInfo == null || fieldInfo.getAnnotations().isEmpty() || !fieldInfo.isTypeOf(objectType) && !fieldInfo.isParameterisedTypeOf(objectType) && !fieldInfo.isArrayOf(objectType)) continue;
                typeFieldInfoMap.put(directedRelationship, fieldInfo);
                return fieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING")) {
                FieldInfo candidateField;
                Set<FieldInfo> candidateRelationshipFields = classInfo.candidateRelationshipFields(relationshipType, relationshipDirection, false);
                for (FieldInfo fieldInfo2 : candidateRelationshipFields) {
                    if (fieldInfo2 == null || fieldInfo2.getAnnotations().isEmpty() || !fieldInfo2.isTypeOf(objectType) && !fieldInfo2.isParameterisedTypeOf(objectType) && !fieldInfo2.isArrayOf(objectType)) continue;
                    typeFieldInfoMap.put(directedRelationship, fieldInfo2);
                    return fieldInfo2;
                }
                for (FieldInfo fieldInfo : candidateRelationshipFields) {
                    if (fieldInfo == null || !fieldInfo.isTypeOf(objectType) && !fieldInfo.isParameterisedTypeOf(objectType) && !fieldInfo.isArrayOf(objectType)) continue;
                    typeFieldInfoMap.put(directedRelationship, fieldInfo);
                    return fieldInfo;
                }
                List<FieldInfo> list = classInfo.findFields(objectType);
                if (list.size() == 1 && !(candidateField = list.iterator().next()).relationshipDirection("UNDIRECTED").equals("INCOMING") && candidateField.relationshipTypeAnnotation() == null) {
                    typeFieldInfoMap.put(directedRelationship, candidateField);
                    return candidateField;
                }
            }
            classInfo = classInfo.directSuperclass();
        }
        return null;
    }

    public static FieldInfo getRelationalReader(ClassInfo classInfo, String relationshipType, String relationshipDirection) {
        DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
        Map relationshipFieldInfoMap = relationalReaderCache.computeIfAbsent(classInfo, key -> new ConcurrentHashMap());
        if (relationshipFieldInfoMap.containsKey(directedRelationship)) {
            return (FieldInfo)relationshipFieldInfoMap.get(directedRelationship);
        }
        while (classInfo != null) {
            FieldInfo fieldInfo = classInfo.relationshipField(relationshipType, relationshipDirection, true);
            if (fieldInfo != null && !fieldInfo.getAnnotations().isEmpty()) {
                relationshipFieldInfoMap.put(directedRelationship, fieldInfo);
                return fieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING")) {
                fieldInfo = classInfo.relationshipField(relationshipType, relationshipDirection, false);
                if (fieldInfo != null && !fieldInfo.getAnnotations().isEmpty()) {
                    relationshipFieldInfoMap.put(directedRelationship, fieldInfo);
                    return fieldInfo;
                }
                if (fieldInfo != null) {
                    relationshipFieldInfoMap.put(directedRelationship, fieldInfo);
                    return fieldInfo;
                }
            }
            classInfo = classInfo.directSuperclass();
        }
        return null;
    }

    public static FieldInfo getIterableField(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection) {
        ClassInfo lookupClassInfo = classInfo;
        DirectedRelationshipForType directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, parameterType);
        Map typeFieldInfoMap = iterableWriterCache.computeIfAbsent(lookupClassInfo, key -> new ConcurrentHashMap());
        if (typeFieldInfoMap.containsKey(directedRelationshipForType)) {
            return (FieldInfo)typeFieldInfoMap.get(directedRelationshipForType);
        }
        while (classInfo != null) {
            FieldInfo fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, true);
            if (fieldInfo != null) {
                EntityAccessManager.cacheIterableFieldWriter(lookupClassInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, fieldInfo, fieldInfo);
                return fieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING") && (fieldInfo = EntityAccessManager.getIterableFieldInfo(classInfo, parameterType, relationshipType, relationshipDirection, false)) != null) {
                EntityAccessManager.cacheIterableFieldWriter(lookupClassInfo, parameterType, relationshipType, relationshipDirection, directedRelationshipForType, fieldInfo, fieldInfo);
                return fieldInfo;
            }
            classInfo = classInfo.directSuperclass();
        }
        return null;
    }

    private static FieldInfo getIterableFieldInfo(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, boolean strict) {
        List<FieldInfo> fieldInfos = classInfo.findIterableFields(parameterType, relationshipType, relationshipDirection, strict);
        if (fieldInfos.size() == 0 && !strict) {
            fieldInfos = classInfo.findIterableFields(parameterType);
        }
        if (fieldInfos.size() == 1) {
            AnnotationInfo relationshipAnnotation;
            FieldInfo candidateFieldInfo = fieldInfos.iterator().next();
            if (candidateFieldInfo.hasAnnotation(Relationship.class) && !relationshipType.equals((relationshipAnnotation = candidateFieldInfo.getAnnotations().get(Relationship.class)).get("type", null))) {
                return null;
            }
            if (relationshipDirection.equals("INCOMING") && candidateFieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") || candidateFieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED")) {
                return candidateFieldInfo;
            }
            if (!relationshipDirection.equals("INCOMING") && !candidateFieldInfo.relationshipDirection("OUTGOING").equals("INCOMING")) {
                return candidateFieldInfo;
            }
        }
        if (fieldInfos.size() > 0) {
            LOGGER.warn("Cannot map iterable of {} to instance of {}. More than one potential matching field found.", parameterType, (Object)classInfo.name());
        }
        return null;
    }

    private static void cacheIterableFieldWriter(ClassInfo classInfo, Class<?> parameterType, String relationshipType, String relationshipDirection, DirectedRelationshipForType directedRelationshipForType, FieldInfo fieldInfo, FieldInfo fieldAccessor) {
        if (fieldInfo.isParameterisedTypeOf(parameterType)) {
            directedRelationshipForType = new DirectedRelationshipForType(relationshipType, relationshipDirection, DescriptorMappings.getType(fieldInfo.getTypeDescriptor()));
        }
        iterableWriterCache.get(classInfo).put(directedRelationshipForType, fieldAccessor);
    }
}

