/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.util.function.Function;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class AttributeConverters {
    public final AttributeConverter<?, ?> forScalar;
    public final AttributeConverter<?, ?> forArray;
    public final Function<String, AttributeConverter<?, ?>> forIterable;

    private AttributeConverters(AttributeConverter<?, ?> forScalar, AttributeConverter<?, ?> forArray, Function<String, AttributeConverter<?, ?>> forIterable) {
        this.forScalar = forScalar;
        this.forArray = forArray;
        this.forIterable = forIterable;
    }

    static class Builder {
        private AttributeConverters buildTarget;

        private Builder(AttributeConverters buildTarget) {
            this.buildTarget = buildTarget;
        }

        static Builder forScalar(AttributeConverter<?, ?> c) {
            return new Builder(new AttributeConverters(c, null, null));
        }

        static AttributeConverters onlyScalar(AttributeConverter<?, ?> c) {
            return Builder.forScalar(c).buildTarget;
        }

        static AttributeConverters onlyArray(AttributeConverter<?, ?> c) {
            return Builder.forScalar(null).array(c).buildTarget;
        }

        Builder array(AttributeConverter<?, ?> c) {
            this.buildTarget = new AttributeConverters(this.buildTarget.forScalar, c, null);
            return this;
        }

        AttributeConverters andIterable(Function<String, AttributeConverter<?, ?>> c) {
            return new AttributeConverters(this.buildTarget.forScalar, this.buildTarget.forArray, c);
        }
    }
}

