/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonPatternTopic;
import org.redisson.ScanResult;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RedissonClient;
import org.redisson.api.SortOrder;
import org.redisson.api.listener.ScoredSortedSetAddListener;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.mapreduce.RedissonCollectionMapReduce;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonScoredSortedSet<V>
extends RedissonExpirable
implements RScoredSortedSet<V> {
    private RedissonClient redisson;

    public RedissonScoredSortedSet(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name);
        this.redisson = redisson;
    }

    public RedissonScoredSortedSet(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name);
        this.redisson = redisson;
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new RedissonCollectionMapReduce(this, this.redisson, this.commandExecutor);
    }

    @Override
    public Collection<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<Collection<V>> readAllAsync() {
        return this.valueRangeAsync(0, -1);
    }

    @Override
    public V pollFirst() {
        return this.get(this.pollFirstAsync());
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    @Override
    public Collection<V> pollFirst(int count) {
        return this.get(this.pollFirstAsync(count));
    }

    @Override
    public Collection<V> pollLast(int count) {
        return this.get(this.pollLastAsync(count));
    }

    @Override
    public RFuture<Collection<V>> pollFirstAsync(int count) {
        if (count <= 0) {
            return new CompletableFutureWrapper<Collection<V>>(Collections.emptyList());
        }
        return this.poll(0, count - 1, RedisCommands.EVAL_LIST);
    }

    @Override
    public RFuture<Collection<V>> pollLastAsync(int count) {
        if (count <= 0) {
            return new CompletableFutureWrapper<Collection<V>>(Collections.emptyList());
        }
        return this.poll(-count, -1, RedisCommands.EVAL_LIST);
    }

    @Override
    public RFuture<V> pollFirstAsync() {
        return this.poll(0, 0, RedisCommands.EVAL_FIRST_LIST);
    }

    @Override
    public RFuture<V> pollLastAsync() {
        return this.poll(-1, -1, RedisCommands.EVAL_FIRST_LIST);
    }

    private <T> RFuture<T> poll(int from, int to, RedisCommand<?> command) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, command, "local v = redis.call('zrange', KEYS[1], ARGV[1], ARGV[2]); if #v > 0 then redis.call('zremrangebyrank', KEYS[1], ARGV[1], ARGV[2]); return v; end return v;", Collections.singletonList(this.getRawName()), from, to);
    }

    @Override
    public V pollFirst(long timeout, TimeUnit unit) {
        return this.get(this.pollFirstAsync(timeout, unit));
    }

    @Override
    public RFuture<V> pollFirstAsync(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZPOPMIN_VALUE, this.getRawName(), this.toSeconds(timeout, unit));
    }

    @Override
    public V pollFirstFromAny(long timeout, TimeUnit unit, String ... queueNames) {
        return this.get(this.pollFirstFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollFirstFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.commandExecutor.pollFromAnyAsync(this.getRawName(), this.codec, RedisCommands.BZPOPMIN_VALUE, this.toSeconds(timeout, unit), queueNames);
    }

    @Override
    public List<V> pollFirstFromAny(Duration duration, int count, String ... queueNames) {
        return this.get(this.pollFirstFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public RFuture<List<V>> pollFirstFromAnyAsync(Duration duration, int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(duration.getSeconds());
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MIN");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZMPOP_SINGLE_LIST, params.toArray());
    }

    @Override
    public List<V> pollFirstFromAny(int count, String ... queueNames) {
        return this.get(this.pollFirstFromAnyAsync(count, queueNames));
    }

    @Override
    public RFuture<List<V>> pollFirstFromAnyAsync(int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MIN");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZMPOP_VALUES, params.toArray());
    }

    @Override
    public Map<String, Map<V, Double>> pollFirstEntriesFromAny(int count, String ... queueNames) {
        return this.get(this.pollFirstEntriesFromAnyAsync(count, queueNames));
    }

    @Override
    public RFuture<Map<String, Map<V, Double>>> pollFirstEntriesFromAnyAsync(int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MIN");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZMPOP, params.toArray());
    }

    @Override
    public Map<String, Map<V, Double>> pollFirstEntriesFromAny(Duration duration, int count, String ... queueNames) {
        return this.get(this.pollFirstEntriesFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public RFuture<Map<String, Map<V, Double>>> pollFirstEntriesFromAnyAsync(Duration duration, int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(duration.getSeconds());
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MIN");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZMPOP, params.toArray());
    }

    @Override
    public V pollLastFromAny(long timeout, TimeUnit unit, String ... queueNames) {
        return this.get(this.pollLastFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollLastFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.commandExecutor.pollFromAnyAsync(this.getRawName(), this.codec, RedisCommands.BZPOPMAX_VALUE, this.toSeconds(timeout, unit), queueNames);
    }

    @Override
    public List<V> pollLastFromAny(Duration duration, int count, String ... queueNames) {
        return this.get(this.pollLastFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public RFuture<List<V>> pollLastFromAnyAsync(Duration duration, int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(duration.getSeconds());
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MAX");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZMPOP_SINGLE_LIST, params.toArray());
    }

    @Override
    public List<V> pollLastFromAny(int count, String ... queueNames) {
        return this.get(this.pollFirstFromAnyAsync(count, queueNames));
    }

    @Override
    public RFuture<List<V>> pollLastFromAnyAsync(int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MAX");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZMPOP_VALUES, params.toArray());
    }

    @Override
    public Map<String, Map<V, Double>> pollLastEntriesFromAny(int count, String ... queueNames) {
        return this.get(this.pollLastEntriesFromAnyAsync(count, queueNames));
    }

    @Override
    public RFuture<Map<String, Map<V, Double>>> pollLastEntriesFromAnyAsync(int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MAX");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZMPOP, params.toArray());
    }

    @Override
    public Map<String, Map<V, Double>> pollLastEntriesFromAny(Duration duration, int count, String ... queueNames) {
        return this.get(this.pollLastEntriesFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public RFuture<Map<String, Map<V, Double>>> pollLastEntriesFromAnyAsync(Duration duration, int count, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(duration.getSeconds());
        params.add(queueNames.length + 1);
        params.add(this.getRawName());
        params.addAll(Arrays.asList(queueNames));
        params.add("MAX");
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZMPOP, params.toArray());
    }

    @Override
    public V pollLast(long timeout, TimeUnit unit) {
        return this.get(this.pollLastAsync(timeout, unit));
    }

    @Override
    public RFuture<V> pollLastAsync(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZPOPMAX_VALUE, this.getRawName(), this.toSeconds(timeout, unit));
    }

    @Override
    public List<V> pollFirst(Duration duration, int count) {
        return this.get(this.pollFirstAsync(duration, count));
    }

    @Override
    public RFuture<List<V>> pollFirstAsync(Duration duration, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZMPOP_SINGLE_LIST, duration.getSeconds(), 1, this.getRawName(), "MIN", "COUNT", count);
    }

    @Override
    public List<V> pollLast(Duration duration, int count) {
        return this.get(this.pollLastAsync(duration, count));
    }

    @Override
    public RFuture<List<V>> pollLastAsync(Duration duration, int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BZMPOP_SINGLE_LIST, duration.getSeconds(), 1, this.getRawName(), "MAX", "COUNT", count);
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public Collection<V> random(int count) {
        return this.get(this.randomAsync(count));
    }

    @Override
    public RFuture<V> randomAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANDMEMBER_SINGLE, this.getRawName());
    }

    @Override
    public RFuture<Collection<V>> randomAsync(int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANDMEMBER, this.getRawName(), count);
    }

    @Override
    public Map<V, Double> randomEntries(int count) {
        return this.get(this.randomEntriesAsync(count));
    }

    @Override
    public RFuture<Map<V, Double>> randomEntriesAsync(int count) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANDMEMBER_ENTRIES, this.getRawName(), count, "WITHSCORES");
    }

    @Override
    public boolean add(double score, V object) {
        return this.get(this.addAsync(score, object));
    }

    @Override
    public Integer addAndGetRank(double score, V object) {
        return this.get(this.addAndGetRankAsync(score, object));
    }

    @Override
    public RFuture<Integer> addAndGetRankAsync(double score, V object) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "redis.call('zadd', KEYS[1], ARGV[1], ARGV[2]);return redis.call('zrank', KEYS[1], ARGV[2]); ", Collections.singletonList(this.getRawName()), new BigDecimal(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public Integer addAndGetRevRank(double score, V object) {
        return this.get(this.addAndGetRevRankAsync(score, object));
    }

    @Override
    public List<Integer> addAndGetRevRank(Map<? extends V, Double> map) {
        return this.get(this.addAndGetRevRankAsync(map));
    }

    @Override
    public RFuture<Integer> addAndGetRevRankAsync(double score, V object) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "redis.call('zadd', KEYS[1], ARGV[1], ARGV[2]);return redis.call('zrevrank', KEYS[1], ARGV[2]); ", Collections.singletonList(this.getRawName()), new BigDecimal(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public RFuture<List<Integer>> addAndGetRevRankAsync(Map<? extends V, Double> map) {
        ArrayList<Object> params = new ArrayList<Object>(map.size() * 2);
        for (Map.Entry<V, Double> t : map.entrySet()) {
            if (t.getKey() == null) {
                throw new NullPointerException("map key can't be null");
            }
            if (t.getValue() == null) {
                throw new NullPointerException("map value can't be null");
            }
            params.add(this.encode((Object)t.getKey()));
            params.add(BigDecimal.valueOf(t.getValue()).toPlainString());
        }
        return this.commandExecutor.evalWriteAsync((String)null, (Codec)IntegerCodec.INSTANCE, RedisCommands.EVAL_INT_LIST, "local r = {} for i, v in ipairs(ARGV) do if i % 2 == 0 then redis.call('zadd', KEYS[1], ARGV[i], ARGV[i-1]); end; end;for i, v in ipairs(ARGV) do if i % 2 == 0 then r[#r+1] = redis.call('zrevrank', KEYS[1], ARGV[i-1]); end; end;return r;", Collections.singletonList(this.getRawName()), params.toArray());
    }

    @Override
    public boolean tryAdd(double score, V object) {
        return this.get(this.tryAddAsync(score, object));
    }

    @Override
    public boolean addIfExists(double score, V object) {
        return this.get(this.addIfExistsAsync(score, object));
    }

    @Override
    public RFuture<Boolean> addIfExistsAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL, this.getRawName(), "XX", "CH", BigDecimal.valueOf(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public boolean addIfLess(double score, V object) {
        return this.get(this.addIfLessAsync(score, object));
    }

    @Override
    public boolean addIfGreater(double score, V object) {
        return this.get(this.addIfGreaterAsync(score, object));
    }

    @Override
    public RFuture<Boolean> addIfLessAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL, this.getRawName(), "LT", "CH", BigDecimal.valueOf(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public RFuture<Boolean> addIfGreaterAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL, this.getRawName(), "GT", "CH", BigDecimal.valueOf(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public V first() {
        return this.get(this.firstAsync());
    }

    @Override
    public RFuture<V> firstAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGE_SINGLE, this.getRawName(), 0, 0);
    }

    @Override
    public V last() {
        return this.get(this.lastAsync());
    }

    @Override
    public RFuture<V> lastAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGE_SINGLE, this.getRawName(), -1, -1);
    }

    @Override
    public Double firstScore() {
        return this.get(this.firstScoreAsync());
    }

    @Override
    public RFuture<Double> firstScoreAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGE_SINGLE_SCORE, this.getRawName(), 0, 0, "WITHSCORES");
    }

    @Override
    public Double lastScore() {
        return this.get(this.lastScoreAsync());
    }

    @Override
    public RFuture<Double> lastScoreAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGE_SINGLE_SCORE, this.getRawName(), -1, -1, "WITHSCORES");
    }

    @Override
    public RFuture<Boolean> addAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL, this.getRawName(), BigDecimal.valueOf(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public int addAll(Map<V, Double> objects) {
        return this.get(this.addAllAsync(objects));
    }

    @Override
    public RFuture<Integer> addAllAsync(Map<V, Double> objects) {
        if (objects.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<String> params = new ArrayList<String>(objects.size() * 2 + 1);
        params.add(this.getRawName());
        for (Map.Entry<V, Double> entry : objects.entrySet()) {
            params.add(BigDecimal.valueOf(entry.getValue()).toPlainString());
            params.add((String)this.encode((Object)entry.getKey()));
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_INT, params.toArray());
    }

    @Override
    public int addAllIfAbsent(Map<V, Double> objects) {
        return this.get(this.addAllIfAbsentAsync(objects));
    }

    @Override
    public RFuture<Integer> addAllIfAbsentAsync(Map<V, Double> objects) {
        if (objects.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<String> params = new ArrayList<String>(objects.size() * 2 + 1);
        params.add(this.getRawName());
        params.add("NX");
        for (Map.Entry<V, Double> entry : objects.entrySet()) {
            params.add(BigDecimal.valueOf(entry.getValue()).toPlainString());
            params.add((String)this.encode((Object)entry.getKey()));
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_INT, params.toArray());
    }

    @Override
    public int addAllIfExist(Map<V, Double> objects) {
        return this.get(this.addAllIfExistAsync(objects));
    }

    @Override
    public RFuture<Integer> addAllIfExistAsync(Map<V, Double> objects) {
        if (objects.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<String> params = new ArrayList<String>(objects.size() * 2 + 1);
        params.add(this.getRawName());
        params.add("XX");
        params.add("CH");
        for (Map.Entry<V, Double> entry : objects.entrySet()) {
            params.add(BigDecimal.valueOf(entry.getValue()).toPlainString());
            params.add((String)this.encode((Object)entry.getKey()));
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_INT, params.toArray());
    }

    @Override
    public int addAllIfGreater(Map<V, Double> objects) {
        return this.get(this.addAllIfGreaterAsync(objects));
    }

    @Override
    public RFuture<Integer> addAllIfGreaterAsync(Map<V, Double> objects) {
        if (objects.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<String> params = new ArrayList<String>(objects.size() * 2 + 1);
        params.add(this.getRawName());
        params.add("GT");
        params.add("CH");
        for (Map.Entry<V, Double> entry : objects.entrySet()) {
            params.add(BigDecimal.valueOf(entry.getValue()).toPlainString());
            params.add((String)this.encode((Object)entry.getKey()));
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_INT, params.toArray());
    }

    @Override
    public int addAllIfLess(Map<V, Double> objects) {
        return this.get(this.addAllIfLessAsync(objects));
    }

    @Override
    public RFuture<Integer> addAllIfLessAsync(Map<V, Double> objects) {
        if (objects.isEmpty()) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        ArrayList<String> params = new ArrayList<String>(objects.size() * 2 + 1);
        params.add(this.getRawName());
        params.add("LT");
        params.add("CH");
        for (Map.Entry<V, Double> entry : objects.entrySet()) {
            params.add(BigDecimal.valueOf(entry.getValue()).toPlainString());
            params.add((String)this.encode((Object)entry.getKey()));
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_INT, params.toArray());
    }

    @Override
    public RFuture<Boolean> tryAddAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL, this.getRawName(), "NX", BigDecimal.valueOf(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public boolean addIfAbsent(double score, V object) {
        return this.get(this.addIfAbsentAsync(score, object));
    }

    @Override
    public RFuture<Boolean> addIfAbsentAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZADD_BOOL, this.getRawName(), "NX", BigDecimal.valueOf(score).toPlainString(), this.encode((Object)object));
    }

    @Override
    public boolean remove(Object object) {
        return this.get(this.removeAsync(object));
    }

    @Override
    public int removeRangeByRank(int startIndex, int endIndex) {
        return this.get(this.removeRangeByRankAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Integer> removeRangeByRankAsync(int startIndex, int endIndex) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREMRANGEBYRANK, this.getRawName(), startIndex, endIndex);
    }

    @Override
    public int removeRangeByScore(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.removeRangeByScoreAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Integer> removeRangeByScoreAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREMRANGEBYSCORE, this.getRawName(), startValue, endValue);
    }

    private String value(double score, boolean inclusive) {
        StringBuilder element = new StringBuilder();
        if (!inclusive) {
            element.append("(");
        }
        if (Double.isInfinite(score)) {
            if (score > 0.0) {
                element.append("+inf");
            } else {
                element.append("-inf");
            }
        } else {
            element.append(BigDecimal.valueOf(score).toPlainString());
        }
        return element.toString();
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public RFuture<Boolean> removeAsync(Object object) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREM, this.getRawName(), this.encode(object));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZCARD_INT, this.getRawName());
    }

    @Override
    public boolean contains(Object object) {
        return this.get(this.containsAsync(object));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZSCORE_CONTAINS, this.getRawName(), this.encode(o));
    }

    @Override
    public Double getScore(V o) {
        return this.get(this.getScoreAsync(o));
    }

    @Override
    public List<Double> getScore(List<V> keys) {
        return this.get(this.getScoreAsync((Collection<V>)keys));
    }

    @Override
    public RFuture<Double> getScoreAsync(V o) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.ZSCORE, this.getRawName(), this.encode((Object)o));
    }

    @Override
    public RFuture<List<Double>> getScoreAsync(Collection<V> elements) {
        return this.commandExecutor.evalReadAsync((String)null, (Codec)DoubleCodec.INSTANCE, RedisCommands.EVAL_LIST, "local r = {} for i, v in ipairs(ARGV) do r[#r+1] = redis.call('ZSCORE', KEYS[1], ARGV[i]); end;return r;", Collections.singletonList(this.getRawName()), this.encode(elements).toArray());
    }

    @Override
    public Integer rank(V o) {
        return this.get(this.rankAsync(o));
    }

    @Override
    public RFuture<Integer> rankAsync(V o) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANK_INT, this.getRawName(), this.encode((Object)o));
    }

    private ScanResult<Object> scanIterator(RedisClient client, long startPos, String pattern, int count) {
        RFuture<ScanResult<Object>> f = this.scanIteratorAsync(client, startPos, pattern, count);
        return this.get(f);
    }

    public RFuture<ScanResult<Object>> scanIteratorAsync(RedisClient client, long startPos, String pattern, int count) {
        if (pattern == null) {
            RFuture<ScanResult<Object>> f = this.commandExecutor.readAsync(client, this.getRawName(), this.codec, RedisCommands.ZSCAN, this.getRawName(), startPos, "COUNT", count);
            return f;
        }
        RFuture<ScanResult<Object>> f = this.commandExecutor.readAsync(client, this.getRawName(), this.codec, RedisCommands.ZSCAN, this.getRawName(), startPos, "MATCH", pattern, "COUNT", count);
        return f;
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null, 10);
    }

    @Override
    public Iterator<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    @Override
    public Iterator<V> iterator(int count) {
        return this.iterator(null, count);
    }

    @Override
    public Iterator<V> iterator(final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonScoredSortedSet.this.scanIterator(client, nextIterPos, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonScoredSortedSet.this.remove(value);
            }
        };
    }

    @Override
    public Iterator<V> distributedIterator(String pattern) {
        String iteratorName = "__redisson_scored_sorted_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, pattern, 10);
    }

    @Override
    public Iterator<V> distributedIterator(int count) {
        String iteratorName = "__redisson_scored_sorted_set_cursor_{" + this.getRawName() + "}";
        return this.distributedIterator(iteratorName, null, count);
    }

    @Override
    public Iterator<V> distributedIterator(final String iteratorName, final String pattern, final int count) {
        return new RedissonBaseIterator<V>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonScoredSortedSet.this.distributedScanIterator(iteratorName, pattern, count);
            }

            @Override
            protected void remove(Object value) {
                RedissonScoredSortedSet.this.remove(value);
            }
        };
    }

    private ScanResult<Object> distributedScanIterator(String iteratorName, String pattern, int count) {
        return this.get(this.distributedScanIteratorAsync(iteratorName, pattern, count));
    }

    private RFuture<ScanResult<Object>> distributedScanIteratorAsync(String iteratorName, String pattern, int count) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        if (pattern != null) {
            args.add(pattern);
        }
        args.add(count);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_ZSCAN, "local cursor = redis.call('get', KEYS[2]); if cursor ~= false then cursor = tonumber(cursor); else cursor = 0;end;if cursor == -1 then return {0, {}}; end;local result; if (#ARGV == 2) then result = redis.call('zscan', KEYS[1], cursor, 'match', ARGV[1], 'count', ARGV[2]); else result = redis.call('zscan', KEYS[1], cursor, 'count', ARGV[1]); end;local next_cursor = result[1]if next_cursor ~= \"0\" then redis.call('setex', KEYS[2], 3600, next_cursor);else redis.call('setex', KEYS[2], 3600, -1);end; local res = {};for i, value in ipairs(result[2]) do if i % 2 == 0 then table.insert(res, result[2][i-1]); end; end;return {result[1], res};", Arrays.asList(this.getRawName(), iteratorName), args.toArray());
    }

    @Override
    public Object[] toArray() {
        List res = (List)this.get(this.valueRangeAsync(0, -1));
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List res = (List)this.get(this.valueRangeAsync(0, -1));
        return res.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(true);
        }
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "for j = 1, #ARGV, 1 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[j]) if expireDateScore == false then return 0;end; end; return 1; ", Collections.singletonList(this.getRawName()), this.encode(c).toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        ArrayList<Object> params = new ArrayList<Object>(c.size() + 1);
        params.add(this.getRawName());
        this.encode(params, c);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZREM, params.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        ArrayList<Integer> params = new ArrayList<Integer>(c.size() * 2);
        for (Object object : c) {
            params.add(0);
            params.add((Integer)this.encode(object));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('zadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('zcard', KEYS[1]); local size = redis.call('zinterstore', KEYS[1], 2, KEYS[1], KEYS[2], 'aggregate', 'sum');redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getRawName(), "redisson_temp__{" + this.getRawName() + "}"), params.toArray());
    }

    @Override
    public Double addScore(V object, Number value) {
        return this.get(this.addScoreAsync(object, value));
    }

    @Override
    public RFuture<Double> addScoreAsync(V object, Number value) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)DoubleCodec.INSTANCE, RedisCommands.ZINCRBY, this.getRawName(), new BigDecimal(value.toString()).toPlainString(), this.encode((Object)object));
    }

    @Override
    public Integer addScoreAndGetRank(V object, Number value) {
        return this.get(this.addScoreAndGetRankAsync(object, value));
    }

    @Override
    public RFuture<Integer> addScoreAndGetRankAsync(V object, Number value) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "redis.call('zincrby', KEYS[1], ARGV[1], ARGV[2]); return redis.call('zrank', KEYS[1], ARGV[2]); ", Collections.singletonList(this.getRawName()), new BigDecimal(value.toString()).toPlainString(), this.encode((Object)object));
    }

    @Override
    public Integer addScoreAndGetRevRank(V object, Number value) {
        return this.get(this.addScoreAndGetRevRankAsync(object, value));
    }

    @Override
    public RFuture<Integer> addScoreAndGetRevRankAsync(V object, Number value) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "redis.call('zincrby', KEYS[1], ARGV[1], ARGV[2]); return redis.call('zrevrank', KEYS[1], ARGV[2]); ", Collections.singletonList(this.getRawName()), new BigDecimal(value.toString()).toPlainString(), this.encode((Object)object));
    }

    @Override
    public Collection<V> valueRange(int startIndex, int endIndex) {
        return this.get(this.valueRangeAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<V>> valueRangeAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGE, this.getRawName(), startIndex, endIndex);
    }

    @Override
    public Collection<V> valueRangeReversed(int startIndex, int endIndex) {
        return this.get(this.valueRangeReversedAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<V>> valueRangeReversedAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZREVRANGE, this.getRawName(), startIndex, endIndex);
    }

    @Override
    public Collection<ScoredEntry<V>> entryRange(int startIndex, int endIndex) {
        return this.get(this.entryRangeAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGE_ENTRY, this.getRawName(), startIndex, endIndex, "WITHSCORES");
    }

    @Override
    public Collection<ScoredEntry<V>> entryRangeReversed(int startIndex, int endIndex) {
        return this.get(this.entryRangeReversedAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZREVRANGE_ENTRY, this.getRawName(), startIndex, endIndex, "WITHSCORES");
    }

    @Override
    public Collection<V> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Collection<V>> valueRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGEBYSCORE_LIST, this.getRawName(), startValue, endValue);
    }

    @Override
    public Collection<V> valueRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Collection<V>> valueRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZREVRANGEBYSCORE, this.getRawName(), endValue, startValue);
    }

    @Override
    public Collection<ScoredEntry<V>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGEBYSCORE_ENTRY, this.getRawName(), startValue, endValue, "WITHSCORES");
    }

    @Override
    public Collection<V> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<V>> valueRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGEBYSCORE_LIST, this.getRawName(), startValue, endValue, "LIMIT", offset, count);
    }

    @Override
    public Collection<V> valueRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<V>> valueRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZREVRANGEBYSCORE, this.getRawName(), endValue, startValue, "LIMIT", offset, count);
    }

    @Override
    public Collection<ScoredEntry<V>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public Collection<ScoredEntry<V>> entryRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.entryRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZRANGEBYSCORE_ENTRY, this.getRawName(), startValue, endValue, "WITHSCORES", "LIMIT", offset, count);
    }

    @Override
    public Collection<ScoredEntry<V>> entryRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.entryRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZREVRANGEBYSCORE_ENTRY, this.getRawName(), endValue, startValue, "WITHSCORES");
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZREVRANGEBYSCORE_ENTRY, this.getRawName(), endValue, startValue, "WITHSCORES", "LIMIT", offset, count);
    }

    @Override
    public RFuture<Integer> revRankAsync(V o) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZREVRANK_INT, this.getRawName(), this.encode((Object)o));
    }

    @Override
    public Integer revRank(V o) {
        return this.get(this.revRankAsync(o));
    }

    @Override
    public RFuture<List<Integer>> revRankAsync(Collection<V> elements) {
        return this.commandExecutor.evalReadAsync((String)null, (Codec)IntegerCodec.INSTANCE, RedisCommands.EVAL_INT_LIST, "local r = {} for i, v in ipairs(ARGV) do r[#r+1] = redis.call('zrevrank', KEYS[1], ARGV[i]); end;return r;", Collections.singletonList(this.getRawName()), this.encode(elements).toArray());
    }

    @Override
    public List<Integer> revRank(Collection<V> elements) {
        return this.get(this.revRankAsync(elements));
    }

    @Override
    public int count(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.countAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Integer> countAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZCOUNT, this.getRawName(), startValue, endValue);
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        return this.intersectionAsync(RScoredSortedSet.Aggregate.SUM, names);
    }

    @Override
    public int intersection(RScoredSortedSet.Aggregate aggregate, String ... names) {
        return this.get(this.intersectionAsync(aggregate, names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 4);
        args.add(this.getRawName());
        args.add(names.length);
        args.addAll(Arrays.asList(names));
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZINTERSTORE_INT, args.toArray());
    }

    @Override
    public int intersection(Map<String, Double> nameWithWeight) {
        return this.get(this.intersectionAsync(nameWithWeight));
    }

    @Override
    public RFuture<Integer> intersectionAsync(Map<String, Double> nameWithWeight) {
        return this.intersectionAsync(RScoredSortedSet.Aggregate.SUM, nameWithWeight);
    }

    @Override
    public int intersection(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        return this.get(this.intersectionAsync(aggregate, nameWithWeight));
    }

    @Override
    public RFuture<Integer> intersectionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        ArrayList<Object> args = new ArrayList<Object>(nameWithWeight.size() * 2 + 5);
        args.add(this.getRawName());
        args.add(nameWithWeight.size());
        args.addAll(nameWithWeight.keySet());
        args.add("WEIGHTS");
        ArrayList<String> weights = new ArrayList<String>();
        for (Double weight : nameWithWeight.values()) {
            weights.add(BigDecimal.valueOf(weight).toPlainString());
        }
        args.addAll(weights);
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZINTERSTORE_INT, args.toArray());
    }

    @Override
    public Collection<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public RFuture<Collection<V>> readIntersectionAsync(String ... names) {
        return this.readIntersectionAsync(RScoredSortedSet.Aggregate.SUM, names);
    }

    @Override
    public Collection<V> readIntersection(RScoredSortedSet.Aggregate aggregate, String ... names) {
        return this.get(this.readIntersectionAsync(aggregate, names));
    }

    @Override
    public RFuture<Collection<V>> readIntersectionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 4);
        args.add(names.length + 1);
        args.add(this.getRawName());
        args.addAll(Arrays.asList(names));
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZINTER, args.toArray());
    }

    @Override
    public Collection<V> readIntersection(Map<String, Double> nameWithWeight) {
        return this.get(this.readIntersectionAsync(nameWithWeight));
    }

    @Override
    public RFuture<Collection<V>> readIntersectionAsync(Map<String, Double> nameWithWeight) {
        return this.readIntersectionAsync(RScoredSortedSet.Aggregate.SUM, nameWithWeight);
    }

    @Override
    public Collection<V> readIntersection(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        return this.get(this.readIntersectionAsync(aggregate, nameWithWeight));
    }

    @Override
    public RFuture<Collection<V>> readIntersectionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        ArrayList<Object> args = new ArrayList<Object>(nameWithWeight.size() * 2 + 5);
        args.add(nameWithWeight.size() + 1);
        args.add(this.getRawName());
        args.addAll(nameWithWeight.keySet());
        args.add("WEIGHTS");
        ArrayList<String> weights = new ArrayList<String>();
        for (Double weight : nameWithWeight.values()) {
            weights.add(BigDecimal.valueOf(weight).toPlainString());
        }
        args.addAll(weights);
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZINTER, args.toArray());
    }

    @Override
    public Integer countIntersection(String ... names) {
        return this.get(this.countIntersectionAsync(names));
    }

    @Override
    public Integer countIntersection(int limit, String ... names) {
        return this.get(this.countIntersectionAsync(limit, names));
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(String ... names) {
        return this.countIntersectionAsync(0, names);
    }

    @Override
    public RFuture<Integer> countIntersectionAsync(int limit, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 1);
        args.add(names.length + 1);
        args.add(this.getRawName());
        args.addAll(Arrays.asList(names));
        if (limit > 0) {
            args.add("LIMIT");
            args.add(limit);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZINTERCARD_INT, args.toArray());
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        return this.unionAsync(RScoredSortedSet.Aggregate.SUM, names);
    }

    @Override
    public int union(RScoredSortedSet.Aggregate aggregate, String ... names) {
        return this.get(this.unionAsync(aggregate, names));
    }

    @Override
    public RFuture<Integer> unionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 4);
        args.add(this.getRawName());
        args.add(names.length);
        args.addAll(Arrays.asList(names));
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZUNIONSTORE_INT, args.toArray());
    }

    @Override
    public int union(Map<String, Double> nameWithWeight) {
        return this.get(this.unionAsync(nameWithWeight));
    }

    @Override
    public RFuture<Integer> unionAsync(Map<String, Double> nameWithWeight) {
        return this.unionAsync(RScoredSortedSet.Aggregate.SUM, nameWithWeight);
    }

    @Override
    public int union(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        return this.get(this.unionAsync(aggregate, nameWithWeight));
    }

    @Override
    public RFuture<Integer> unionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        ArrayList<Object> args = new ArrayList<Object>(nameWithWeight.size() * 2 + 5);
        args.add(this.getRawName());
        args.add(nameWithWeight.size());
        args.addAll(nameWithWeight.keySet());
        args.add("WEIGHTS");
        ArrayList<String> weights = new ArrayList<String>();
        for (Double weight : nameWithWeight.values()) {
            weights.add(BigDecimal.valueOf(weight).toPlainString());
        }
        args.addAll(weights);
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Collection<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public RFuture<Collection<V>> readUnionAsync(String ... names) {
        return this.readUnionAsync(RScoredSortedSet.Aggregate.SUM, names);
    }

    @Override
    public Collection<V> readUnion(RScoredSortedSet.Aggregate aggregate, String ... names) {
        return this.get(this.readUnionAsync(aggregate, names));
    }

    @Override
    public RFuture<Collection<V>> readUnionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 4);
        args.add(names.length + 1);
        args.add(this.getRawName());
        args.addAll(Arrays.asList(names));
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZUNION, args.toArray());
    }

    @Override
    public Collection<V> readUnion(Map<String, Double> nameWithWeight) {
        return this.get(this.readUnionAsync(nameWithWeight));
    }

    @Override
    public RFuture<Collection<V>> readUnionAsync(Map<String, Double> nameWithWeight) {
        return this.readUnionAsync(RScoredSortedSet.Aggregate.SUM, nameWithWeight);
    }

    @Override
    public Collection<V> readUnion(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        return this.get(this.readUnionAsync(aggregate, nameWithWeight));
    }

    @Override
    public RFuture<Collection<V>> readUnionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        ArrayList<Object> args = new ArrayList<Object>(nameWithWeight.size() * 2 + 5);
        args.add(nameWithWeight.size() + 1);
        args.add(this.getRawName());
        args.addAll(nameWithWeight.keySet());
        args.add("WEIGHTS");
        ArrayList<String> weights = new ArrayList<String>();
        for (Double weight : nameWithWeight.values()) {
            weights.add(BigDecimal.valueOf(weight).toPlainString());
        }
        args.addAll(weights);
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZUNION, args.toArray());
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return this.get(this.readSortAsync(order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), order});
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "LIMIT", offset, count, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, "LIMIT", offset, count, order});
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, false);
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order) {
        return this.get(this.readSortAlphaAsync(order));
    }

    @Override
    public Set<V> readSortAlpha(SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(order, offset, count));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, order));
    }

    @Override
    public Set<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, order, offset, count));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "ALPHA", order});
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "LIMIT", offset, count, "ALPHA", order});
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, "ALPHA", order});
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getRawName(), "BY", byPattern, "LIMIT", offset, count, "ALPHA", order});
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAlphaAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.readSortAsync(byPattern, getPatterns, order, offset, count, true);
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.get(this.sortToAsync(destName, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, null, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, byPattern, Collections.emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.sortToAsync(destName, byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        for (String pattern : getPatterns) {
            params.add("GET");
            params.add(pattern);
        }
        params.add((Object)order);
        params.add("STORE");
        params.add(destName);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SORT_TO, params.toArray());
    }

    private <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count, boolean alpha) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        if (getPatterns != null) {
            for (String pattern : getPatterns) {
                params.add("GET");
                params.add(pattern);
            }
        }
        if (alpha) {
            params.add("ALPHA");
        }
        if (order != null) {
            params.add((Object)order);
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SORT_SET, params.toArray());
    }

    @Override
    public Collection<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public RFuture<Collection<V>> readDiffAsync(String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 2);
        args.add(names.length + 1);
        args.add(this.getRawName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.ZDIFF, args.toArray());
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 2);
        args.add(this.getRawName());
        args.add(names.length);
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZDIFFSTORE_INT, args.toArray());
    }

    @Override
    public int rangeTo(String destName, int startIndex, int endIndex) {
        return this.get(this.rangeToAsync(destName, startIndex, endIndex));
    }

    @Override
    public int rangeTo(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.rangeToAsync(destName, startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public int rangeTo(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.rangeToAsync(destName, startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public int revRangeTo(String destName, int startIndex, int endIndex) {
        return this.get(this.revRangeToAsync(destName, startIndex, endIndex));
    }

    @Override
    public int revRangeTo(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.revRangeToAsync(destName, startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public int revRangeTo(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.revRangeToAsync(destName, startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public RFuture<Integer> revRangeToAsync(String destName, int startIndex, int endIndex) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANGESTORE, destName, this.getRawName(), startIndex, endIndex, "REV");
    }

    @Override
    public RFuture<Integer> revRangeToAsync(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANGESTORE, destName, this.getRawName(), startValue, endValue, "BYSCORE", "REV");
    }

    @Override
    public RFuture<Integer> revRangeToAsync(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANGESTORE, destName, this.getRawName(), startValue, endValue, "BYSCORE", "REV", "LIMIT", offset, count);
    }

    @Override
    public RFuture<Integer> rangeToAsync(String destName, int startIndex, int endIndex) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANGESTORE, destName, this.getRawName(), startIndex, endIndex);
    }

    @Override
    public RFuture<Integer> rangeToAsync(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANGESTORE, destName, this.getRawName(), startValue, endValue, "BYSCORE");
    }

    @Override
    public RFuture<Integer> rangeToAsync(String destName, double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.ZRANGESTORE, destName, this.getRawName(), startValue, endValue, "BYSCORE", "LIMIT", offset, count);
    }

    @Override
    public RFuture<V> takeFirstAsync() {
        return this.pollFirstAsync(0L, TimeUnit.SECONDS);
    }

    @Override
    public RFuture<V> takeLastAsync() {
        return this.pollLastAsync(0L, TimeUnit.SECONDS);
    }

    @Override
    public V takeFirst() {
        return this.get(this.takeFirstAsync());
    }

    @Override
    public V takeLast() {
        return this.get(this.takeLastAsync());
    }

    @Override
    public int subscribeOnFirstElements(Consumer<V> consumer) {
        return this.commandExecutor.getConnectionManager().getElementsSubscribeService().subscribeOnElements(this::takeFirstAsync, consumer);
    }

    @Override
    public int subscribeOnLastElements(Consumer<V> consumer) {
        return this.commandExecutor.getConnectionManager().getElementsSubscribeService().subscribeOnElements(this::takeLastAsync, consumer);
    }

    @Override
    public void unsubscribe(int listenerId) {
        this.commandExecutor.getConnectionManager().getElementsSubscribeService().unsubscribe(listenerId);
    }

    @Override
    public Stream<V> stream() {
        return this.toStream(this.iterator());
    }

    @Override
    public Stream<V> stream(String pattern) {
        return this.toStream(this.iterator(pattern));
    }

    @Override
    public Stream<V> stream(int count) {
        return this.toStream(this.iterator(count));
    }

    @Override
    public Stream<V> stream(String pattern, int count) {
        return this.toStream(this.iterator(pattern, count));
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof ScoredSortedSetAddListener) {
            return this.addListener("__keyevent@*:zadd", (ScoredSortedSetAddListener)listener, ScoredSortedSetAddListener::onAdd);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof ScoredSortedSetAddListener) {
            return this.addListenerAsync("__keyevent@*:zadd", (ScoredSortedSetAddListener)listener, ScoredSortedSetAddListener::onAdd);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        RedissonPatternTopic expiredTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:zadd");
        expiredTopic.removeListener(listenerId);
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RedissonPatternTopic setTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:zadd");
        RFuture<Void> f1 = setTopic.removeListenerAsync(listenerId);
        RFuture<Void> f2 = super.removeListenerAsync(listenerId);
        CompletableFuture<Void> f = CompletableFuture.allOf(f1.toCompletableFuture(), f2.toCompletableFuture());
        return new CompletableFutureWrapper<Void>(f);
    }
}

