/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.redisson.RedissonMultimap;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.command.CommandAsyncExecutor;

abstract class RedissonMultiMapIterator<K, V, M>
implements Iterator<M> {
    private Iterator<Map.Entry<Object, Object>> keysIter;
    protected long keysIterPos = 0L;
    private K currentKey;
    private Iterator<V> valuesIter;
    protected long valuesIterPos = 0L;
    protected RedisClient client;
    private boolean finished;
    private boolean keysFinished;
    private boolean removeExecuted;
    protected V entry;
    final RedissonMultimap<K, V> map;
    final CommandAsyncExecutor commandExecutor;
    final Codec codec;

    RedissonMultiMapIterator(RedissonMultimap<K, V> map, CommandAsyncExecutor commandExecutor, Codec codec) {
        this.map = map;
        this.commandExecutor = commandExecutor;
        this.codec = codec;
    }

    @Override
    public boolean hasNext() {
        if (this.valuesIter != null && this.valuesIter.hasNext()) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        do {
            if (!(this.keysFinished || this.keysIter != null && this.keysIter.hasNext())) {
                MapScanResult<Object, Object> res = this.map.scanIterator(this.client, this.keysIterPos);
                this.client = res.getRedisClient();
                this.keysIter = res.getMap().entrySet().iterator();
                this.keysIterPos = res.getPos();
                if (res.getPos() == 0L) {
                    this.keysFinished = true;
                }
            }
            while (this.keysIter.hasNext()) {
                Map.Entry<Object, Object> e = this.keysIter.next();
                this.currentKey = e.getKey();
                String name = e.getValue().toString();
                this.valuesIter = this.getIterator(name);
                if (!this.valuesIter.hasNext()) continue;
                return true;
            }
        } while (this.keysIterPos != 0L);
        this.finished = true;
        return false;
    }

    protected abstract Iterator<V> getIterator(String var1);

    @Override
    public M next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No such element at index");
        }
        this.entry = this.valuesIter.next();
        this.removeExecuted = false;
        return this.getValue(this.entry);
    }

    M getValue(V entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(this.currentKey, entry){

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void remove() {
        if (this.removeExecuted) {
            throw new IllegalStateException("Element been already deleted");
        }
        if (this.valuesIter == null || this.entry == null) {
            throw new IllegalStateException();
        }
        this.map.remove(this.currentKey, this.entry);
        this.removeExecuted = true;
    }
}

