/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support.state;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.support.state.AbstractState;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepHolder;
import org.springframework.batch.core.step.StepLocator;

public class StepState
extends AbstractState
implements StepLocator,
StepHolder {
    private final Step step;

    public StepState(Step step) {
        super(step.getName());
        this.step = step;
    }

    public StepState(String name, Step step) {
        super(name);
        this.step = step;
    }

    @Override
    public FlowExecutionStatus handle(FlowExecutor executor) throws Exception {
        executor.abandonStepExecution();
        return new FlowExecutionStatus(executor.executeStep(this.step));
    }

    @Override
    public Step getStep() {
        return this.step;
    }

    @Override
    public boolean isEndState() {
        return false;
    }

    @Override
    public Collection<String> getStepNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.step.getName());
        if (this.step instanceof StepLocator) {
            names.addAll(((StepLocator)((Object)this.step)).getStepNames());
        }
        return names;
    }

    @Override
    public Step getStep(String stepName) throws NoSuchStepException {
        Step result = null;
        if (this.step.getName().equals(stepName)) {
            result = this.step;
        } else if (this.step instanceof StepLocator) {
            result = ((StepLocator)((Object)this.step)).getStep(stepName);
        }
        return result;
    }
}

