/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.util.StringUtils;

public final class B3Utils {
    public static String toB3String(Span span) {
        String traceId = span.traceIdString();
        String spanId = Span.idToHex(span.getSpanId());
        boolean sampled = span.isExportable();
        List<Long> parents = span.getParents();
        StringBuilder b3 = new StringBuilder().append(traceId).append("-").append(spanId).append("-").append(sampled ? "1" : "0");
        if (parents != null && !parents.isEmpty()) {
            b3 = b3.append("-").append(Span.idToHex(parents.get(0)));
        }
        return b3.toString();
    }

    public static String traceId(String b3HeaderName, String fallbackHeaderName, Map<String, String> carrier) {
        String[] split;
        String b3 = carrier.get(b3HeaderName);
        if (StringUtils.hasText((String)b3) && (split = b3.split("-")).length > 1) {
            return split[0];
        }
        return carrier.get(fallbackHeaderName);
    }

    public static String spanId(String b3HeaderName, String fallbackHeaderName, Map<String, String> carrier) {
        String[] split;
        String b3 = carrier.get(b3HeaderName);
        if (StringUtils.hasText((String)b3) && (split = b3.split("-")).length > 1) {
            return split[1];
        }
        return carrier.get(fallbackHeaderName);
    }

    public static String parentSpanId(String b3HeaderName, String fallbackHeaderName, Map<String, String> carrier) {
        String[] split;
        String b3 = carrier.get(b3HeaderName);
        if (StringUtils.hasText((String)b3) && (split = b3.split("-")).length == 4) {
            return split[3];
        }
        return carrier.get(fallbackHeaderName);
    }

    public static Sampled sampled(String b3HeaderName, String fallbackSampledHeaderName, String fallbackFlagsHeaderName, Map<String, String> carrier) {
        String[] split;
        String b3 = carrier.get(b3HeaderName);
        if (StringUtils.hasText((String)b3) && (split = b3.split("-")).length > 2) {
            return Sampled.from(split[2]);
        }
        String fallbackFlag = carrier.get(fallbackFlagsHeaderName);
        if ("1".equals(fallbackFlag)) {
            return Sampled.DEBUG;
        }
        return Sampled.from(carrier.get(fallbackSampledHeaderName));
    }

    public static enum Sampled {
        SAMPLED('1'),
        NOT_SAMPLED('0'),
        DEBUG('d');

        final char sampledChar;

        private Sampled(char sampledChar) {
            this.sampledChar = sampledChar;
        }

        static Sampled from(String value) {
            if (StringUtils.hasText((String)value)) {
                switch (value) {
                    case "1": {
                        return SAMPLED;
                    }
                    case "0": {
                        return NOT_SAMPLED;
                    }
                    case "d": {
                        return DEBUG;
                    }
                }
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.sampledChar);
        }
    }
}

