/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.cloud.sleuth.instrument.messaging.TraceChannelInterceptor;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.InterceptableChannel;

@Aspect
class TraceDestinationResolverAspect {
    private final TraceChannelInterceptor interceptor;

    TraceDestinationResolverAspect(TraceChannelInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Pointcut(value="execution(public * org.springframework.messaging.core.DestinationResolver.resolveDestination(..))")
    private void anyDestinationResolver() {
    }

    @Around(value="anyDestinationResolver()")
    public Object addInterceptor(ProceedingJoinPoint pjp) throws Throwable {
        InterceptableChannel interceptorAware;
        Object destination = pjp.proceed();
        if (destination instanceof ChannelInterceptorAware) {
            ChannelInterceptorAware interceptorAware2 = (ChannelInterceptorAware)destination;
            if (!this.hasTracedChannelInterceptor(interceptorAware2.getChannelInterceptors())) {
                interceptorAware2.addInterceptor((ChannelInterceptor)this.interceptor);
            }
        } else if (destination instanceof InterceptableChannel && !this.hasTracedChannelInterceptor((interceptorAware = (InterceptableChannel)destination).getInterceptors())) {
            interceptorAware.addInterceptor((ChannelInterceptor)this.interceptor);
        }
        return destination;
    }

    private boolean hasTracedChannelInterceptor(List<ChannelInterceptor> interceptors) {
        for (ChannelInterceptor channelInterceptor : interceptors) {
            if (!(channelInterceptor instanceof TraceChannelInterceptor)) continue;
            return true;
        }
        return false;
    }
}

