/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.scheduling;

import java.util.regex.Pattern;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

@Aspect
public class TraceSchedulingAspect {
    private static final String SCHEDULED_COMPONENT = "scheduled";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final Pattern skipPattern;

    public TraceSchedulingAspect(Tracer tracer, TraceKeys traceKeys, Pattern skipPattern) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.skipPattern = skipPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object traceBackgroundThread(ProceedingJoinPoint pjp) throws Throwable {
        if (this.skipPattern.matcher(pjp.getTarget().getClass().getName()).matches()) {
            return pjp.proceed();
        }
        String spanName = SpanNameUtil.toLowerHyphen(pjp.getSignature().getName());
        Span span = this.tracer.createSpan(spanName);
        this.tracer.addTag("lc", SCHEDULED_COMPONENT);
        this.tracer.addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getClassNameKey(), pjp.getTarget().getClass().getSimpleName());
        this.tracer.addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getMethodNameKey(), pjp.getSignature().getName());
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            if (this.tracer.isTracing()) {
                this.tracer.close(span);
            }
        }
    }
}

