/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.regex.Pattern;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanExtractor;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.ZipkinHttpSpanExtractor;
import org.springframework.cloud.sleuth.instrument.web.ZipkinHttpSpanInjector;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceKeys.class, SleuthWebProperties.class})
public class TraceHttpAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HttpTraceKeysInjector httpTraceKeysInjector(Tracer tracer, TraceKeys traceKeys) {
        return new HttpTraceKeysInjector(tracer, traceKeys);
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpSpanExtractor httpSpanExtractor(SkipPatternProvider skipPatternProvider) {
        return new ZipkinHttpSpanExtractor(skipPatternProvider.skipPattern());
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpSpanInjector httpSpanInjector() {
        return new ZipkinHttpSpanInjector();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties"})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    public SkipPatternProvider defaultSkipPatternBean(SleuthWebProperties sleuthWebProperties) {
        return TraceHttpAutoConfiguration.defaultSkipPatternProvider(sleuthWebProperties.getSkipPattern());
    }

    private static SkipPatternProvider defaultSkipPatternProvider(final String skipPattern) {
        return new SkipPatternProvider(){

            @Override
            public Pattern skipPattern() {
                return TraceHttpAutoConfiguration.defaultSkipPattern(skipPattern);
            }
        };
    }

    private static Pattern defaultSkipPattern(String skipPattern) {
        return StringUtils.hasText((String)skipPattern) ? Pattern.compile(skipPattern) : Pattern.compile("/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream");
    }

    @Configuration
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    @EnableConfigurationProperties(value={SleuthWebProperties.class})
    protected static class SkipPatternProviderConfig {
        protected SkipPatternProviderConfig() {
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SkipPatternProvider skipPatternForManagementServerProperties(final ManagementServerProperties managementServerProperties, final SleuthWebProperties sleuthWebProperties) {
            return new SkipPatternProvider(){

                @Override
                public Pattern skipPattern() {
                    return SkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties, sleuthWebProperties);
                }
            };
        }

        static Pattern getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties, SleuthWebProperties sleuthWebProperties) {
            String skipPattern = sleuthWebProperties.getSkipPattern();
            if (StringUtils.hasText((String)skipPattern) && StringUtils.hasText((String)managementServerProperties.getContextPath())) {
                return Pattern.compile(skipPattern + "|" + managementServerProperties.getContextPath() + ".*");
            }
            if (StringUtils.hasText((String)managementServerProperties.getContextPath())) {
                return Pattern.compile(managementServerProperties.getContextPath() + ".*");
            }
            return TraceHttpAutoConfiguration.defaultSkipPattern(skipPattern);
        }

        @Bean
        @ConditionalOnMissingBean(value={ManagementServerProperties.class})
        public SkipPatternProvider defaultSkipPatternBeanIfManagementServerPropsArePresent(SleuthWebProperties sleuthWebProperties) {
            return TraceHttpAutoConfiguration.defaultSkipPatternProvider(sleuthWebProperties.getSkipPattern());
        }
    }
}

