/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Map;
import org.springframework.cloud.sleuth.B3Utils;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.ZipkinHttpSpanMapper;
import org.springframework.util.StringUtils;

public class ZipkinHttpSpanInjector
implements HttpSpanInjector {
    private static final ZipkinHttpSpanMapper SPAN_CARRIER_MAPPER = new ZipkinHttpSpanMapper();

    @Override
    public void inject(Span span, SpanTextMap map) {
        Map<String, String> carrier = SPAN_CARRIER_MAPPER.convert(map);
        this.setHeader(map, carrier, "b3", B3Utils.toB3String(span));
        this.setHeader(map, carrier, "X-B3-TraceId", span.traceIdString());
        this.setIdHeader(map, carrier, "X-B3-SpanId", span.getSpanId());
        this.setHeader(map, carrier, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setHeader(map, carrier, "X-Span-Name", span.getName());
        this.setIdHeader(map, carrier, "X-B3-ParentSpanId", this.getParentId(span));
        this.setHeader(map, carrier, "X-Process-Id", span.getProcessId());
        for (Map.Entry<String, String> entry : span.baggageItems()) {
            map.put(this.prefixedKey(entry.getKey()), entry.getValue());
        }
    }

    private String prefixedKey(String key) {
        if (key.startsWith("baggage-")) {
            return key;
        }
        return "baggage-" + key;
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    private void setIdHeader(SpanTextMap map, Map<String, String> carrier, String name, Long value) {
        if (value != null) {
            this.setHeader(map, carrier, name, Span.idToHex(value));
        }
    }

    private void setHeader(SpanTextMap map, Map<String, String> carrier, String name, String value) {
        if (StringUtils.hasText((String)value) && !carrier.containsKey(name)) {
            map.put(name, value);
        }
    }
}

