/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.cloud.sleuth.SpanTextMap;

class ZipkinHttpSpanMapper {
    static final String HEADER_DELIMITER = "-";
    static final String BAGGAGE_PREFIX = "baggage-";
    static final String URI_HEADER = "X-Span-Uri";
    private static Comparator<String> IGNORE_CASE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    };
    private static final Set<String> SPAN_FIELDS;

    ZipkinHttpSpanMapper() {
    }

    Map<String, String> convert(SpanTextMap textMap) {
        TreeMap<String, String> carrier = new TreeMap<String, String>(IGNORE_CASE_COMPARATOR);
        for (Map.Entry<String, String> entry : textMap) {
            if (!this.isAcceptable(entry.getKey())) continue;
            carrier.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(carrier);
    }

    private boolean isAcceptable(String key) {
        return SPAN_FIELDS.contains(key) || key.startsWith(BAGGAGE_PREFIX);
    }

    static {
        TreeSet<String> fields = new TreeSet<String>(IGNORE_CASE_COMPARATOR);
        Collections.addAll(fields, "b3", "X-B3-Flags", "X-B3-TraceId", "X-B3-SpanId", "X-Process-Id", "X-Span-Name", "X-B3-ParentSpanId", "X-B3-Sampled", URI_HEADER);
        SPAN_FIELDS = Collections.unmodifiableSet(fields);
    }
}

