/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.ZuulFilterResult;
import com.netflix.zuul.context.RequestContext;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.cloud.sleuth.instrument.web.TraceRequestAttributes;
import org.springframework.cloud.sleuth.instrument.zuul.RequestContextTextMap;

public class TracePreZuulFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String TRACE_REQUEST_ATTR = TraceFilter.class.getName() + ".TRACE";
    private static final String TRACE_CLOSE_SPAN_REQUEST_ATTR = TraceFilter.class.getName() + ".CLOSE_SPAN";
    private static final String ZUUL_COMPONENT = "zuul";
    private final Tracer tracer;
    private final HttpSpanInjector spanInjector;
    private final HttpTraceKeysInjector httpTraceKeysInjector;
    private final ErrorParser errorParser;

    public TracePreZuulFilter(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector, ErrorParser errorParser) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
        this.httpTraceKeysInjector = httpTraceKeysInjector;
        this.errorParser = errorParser;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        return null;
    }

    public ZuulFilterResult runFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        Span span = this.getCurrentSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current span is " + span + ""));
        }
        this.markRequestAsHandled(ctx);
        Span newSpan = this.tracer.createSpan(span.getName(), span);
        newSpan.tag("lc", ZUUL_COMPONENT);
        this.spanInjector.inject(newSpan, new RequestContextTextMap(ctx));
        this.httpTraceKeysInjector.addRequestTags(newSpan, URI.create(ctx.getRequest().getRequestURI()), ctx.getRequest().getMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)("New Zuul Span is " + newSpan + ""));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting attributes for TraceFilter to pick up later");
        }
        RequestContext.getCurrentContext().getRequest().setAttribute(TRACE_REQUEST_ATTR, (Object)this.tracer.getCurrentSpan());
        RequestContext.getCurrentContext().getRequest().setAttribute(TRACE_CLOSE_SPAN_REQUEST_ATTR, (Object)true);
        ZuulFilterResult result = super.runFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result of Zuul filter is [" + result.getStatus() + "]"));
        }
        if (ExecutionStatus.SUCCESS != result.getStatus()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The result of Zuul filter execution was not successful thus will close the current span " + newSpan));
            }
            this.errorParser.parseErrorTags(newSpan, result.getException());
            this.tracer.close(newSpan);
        }
        return result;
    }

    private void markRequestAsHandled(RequestContext ctx) {
        ctx.getRequest().setAttribute(TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR, (Object)"true");
        ctx.getRequest().setAttribute(TraceRequestAttributes.ERROR_HANDLED_SPAN_REQUEST_ATTR, (Object)"true");
    }

    private Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }
}

