/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;

class TraceRibbonCommandFactory
implements RibbonCommandFactory,
SmartInitializingSingleton {
    private Tracer tracer;
    private HttpTraceKeysInjector httpTraceKeysInjector;
    private final RibbonCommandFactory delegate;
    private final BeanFactory beanFactory;

    TraceRibbonCommandFactory(RibbonCommandFactory delegate, BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    private void initialize() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        if (this.httpTraceKeysInjector == null) {
            this.httpTraceKeysInjector = (HttpTraceKeysInjector)this.beanFactory.getBean(HttpTraceKeysInjector.class);
        }
    }

    public RibbonCommand create(RibbonCommandContext context) {
        this.initialize();
        RibbonCommand ribbonCommand = this.delegate.create(context);
        Span span = this.tracer.getCurrentSpan();
        this.httpTraceKeysInjector.addRequestTags(span, context.uri(), context.getMethod());
        return ribbonCommand;
    }

    public void afterSingletonsInstantiated() {
        this.initialize();
    }
}

