/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.builder;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.neo4j.repository.query.derived.builder.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

public class DistanceComparisonBuilder
extends FilterBuilder {
    public DistanceComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        Point point;
        Distance distance;
        Object firstArg = params.pop();
        Object secondArg = params.pop();
        if (firstArg instanceof Distance && secondArg instanceof Point) {
            distance = (Distance)firstArg;
            point = (Point)secondArg;
        } else if (secondArg instanceof Distance && firstArg instanceof Point) {
            distance = (Distance)secondArg;
            point = (Point)firstArg;
        } else {
            throw new IllegalArgumentException("findNear requires an argument of type Distance and an argument of type Point");
        }
        double meters = distance.getMetric() == Metrics.KILOMETERS ? distance.getValue() * 1000.0 : (distance.getMetric() == Metrics.MILES ? distance.getValue() / 6.2137E-4 : distance.getValue());
        DistanceFromPoint distanceFromPoint = new DistanceFromPoint(Double.valueOf(point.getX()), Double.valueOf(point.getY()), Double.valueOf(distance.getValue() * meters));
        DistanceComparison distanceComparison = new DistanceComparison(distanceFromPoint);
        Filter filter = new Filter();
        filter.setPropertyName(this.propertyName());
        filter.setOwnerEntityType(this.entityType);
        filter.setBooleanOperator(this.booleanOperator);
        filter.setNegated(this.isNegated());
        filter.setFunction((FilterFunction)distanceComparison);
        filter.setComparisonOperator(ComparisonOperator.LESS_THAN);
        this.setNestedAttributes(this.part, filter);
        return Collections.singletonList(filter);
    }
}

