/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.repository.query.GraphQueryLookupStrategy;
import org.springframework.data.neo4j.repository.support.GraphEntityInformation;
import org.springframework.data.neo4j.repository.support.SimpleNeo4jRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;

public class Neo4jRepositoryFactory
extends RepositoryFactorySupport {
    private final Session session;

    public Neo4jRepositoryFactory(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null!");
        this.session = session;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> type) {
        Assert.notNull(type, (String)"Domain class must not be null!");
        Assert.notNull((Object)this.session, (String)"Session must not be null!");
        return new GraphEntityInformation(((Neo4jSession)this.session).metaData(), type);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        return this.getTargetRepositoryViaReflection(information, new Object[]{information.getDomainType(), this.session});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleNeo4jRepository.class;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return new GraphQueryLookupStrategy(this.session);
    }
}

