/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.AggregateMessageDeliveryException;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.MessageHandlingTaskDecorator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.MessageHandlingRunnable;
import org.springframework.util.Assert;

public class UnicastingDispatcher
extends AbstractDispatcher {
    private final MessageHandler dispatchHandler = message -> this.doDispatch(message);
    private final Executor executor;
    private volatile boolean failover = true;
    private volatile LoadBalancingStrategy loadBalancingStrategy;
    private volatile MessageHandlingTaskDecorator messageHandlingTaskDecorator = task -> task;

    public UnicastingDispatcher() {
        this.executor = null;
    }

    public UnicastingDispatcher(Executor executor) {
        this.executor = executor;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public void setLoadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
        this.loadBalancingStrategy = loadBalancingStrategy;
    }

    public void setMessageHandlingTaskDecorator(MessageHandlingTaskDecorator messageHandlingTaskDecorator) {
        Assert.notNull((Object)messageHandlingTaskDecorator, (String)"'messageHandlingTaskDecorator' must not be null.");
        this.messageHandlingTaskDecorator = messageHandlingTaskDecorator;
    }

    @Override
    public final boolean dispatch(Message<?> message) {
        if (this.executor != null) {
            Runnable task = this.createMessageHandlingTask(message);
            this.executor.execute(task);
            return true;
        }
        return this.doDispatch(message);
    }

    private Runnable createMessageHandlingTask(final Message<?> message) {
        MessageHandlingRunnable task = new MessageHandlingRunnable(){

            public void run() {
                UnicastingDispatcher.this.doDispatch(message);
            }

            public Message<?> getMessage() {
                return message;
            }

            public MessageHandler getMessageHandler() {
                return UnicastingDispatcher.this.dispatchHandler;
            }
        };
        return this.messageHandlingTaskDecorator.decorate(task);
    }

    private boolean doDispatch(Message<?> message) {
        if (this.tryOptimizedDispatch(message)) {
            return true;
        }
        boolean success = false;
        Iterator<MessageHandler> handlerIterator = this.getHandlerIterator(message);
        if (!handlerIterator.hasNext()) {
            throw new MessageDispatchingException(message, "Dispatcher has no subscribers");
        }
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        while (!success && handlerIterator.hasNext()) {
            MessageHandler handler = handlerIterator.next();
            try {
                handler.handleMessage(message);
                success = true;
            }
            catch (Exception e) {
                RuntimeException runtimeException = this.wrapExceptionIfNecessary(message, e);
                exceptions.add(runtimeException);
                this.handleExceptions(exceptions, message, !handlerIterator.hasNext());
            }
        }
        return success;
    }

    private Iterator<MessageHandler> getHandlerIterator(Message<?> message) {
        if (this.loadBalancingStrategy != null) {
            return this.loadBalancingStrategy.getHandlerIterator(message, this.getHandlers());
        }
        return this.getHandlers().iterator();
    }

    private void handleExceptions(List<RuntimeException> allExceptions, Message<?> message, boolean isLast) {
        if (isLast || !this.failover) {
            if (allExceptions != null && allExceptions.size() == 1) {
                throw allExceptions.get(0);
            }
            throw new AggregateMessageDeliveryException(message, "All attempts to deliver Message to MessageHandlers failed.", allExceptions);
        }
    }
}

