/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.codec.Codec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.json.JsonToObjectTransformer;
import org.springframework.integration.json.ObjectToJsonTransformer;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.transformer.DecodingTransformer;
import org.springframework.integration.transformer.EncodingPayloadTransformer;
import org.springframework.integration.transformer.MapToObjectTransformer;
import org.springframework.integration.transformer.ObjectToMapTransformer;
import org.springframework.integration.transformer.ObjectToStringTransformer;
import org.springframework.integration.transformer.PayloadDeserializingTransformer;
import org.springframework.integration.transformer.PayloadSerializingTransformer;
import org.springframework.integration.transformer.PayloadTypeConvertingTransformer;
import org.springframework.integration.transformer.StreamTransformer;
import org.springframework.integration.transformer.SyslogToMapTransformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class Transformers {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    public static ObjectToStringTransformer objectToString() {
        return Transformers.objectToString(null);
    }

    public static ObjectToStringTransformer objectToString(String charset) {
        return charset != null ? new ObjectToStringTransformer(charset) : new ObjectToStringTransformer();
    }

    public static ObjectToMapTransformer toMap() {
        return new ObjectToMapTransformer();
    }

    public static ObjectToMapTransformer toMap(boolean shouldFlattenKeys) {
        ObjectToMapTransformer transformer = new ObjectToMapTransformer();
        transformer.setShouldFlattenKeys(shouldFlattenKeys);
        return transformer;
    }

    public static ObjectToMapTransformer toMap(JsonObjectMapper<?, ?> jsonObjectMapper) {
        return new ObjectToMapTransformer(jsonObjectMapper);
    }

    public static ObjectToMapTransformer toMap(JsonObjectMapper<?, ?> jsonObjectMapper, boolean shouldFlattenKeys) {
        ObjectToMapTransformer transformer = new ObjectToMapTransformer(jsonObjectMapper);
        transformer.setShouldFlattenKeys(shouldFlattenKeys);
        return transformer;
    }

    public static MapToObjectTransformer fromMap(Class<?> targetClass) {
        return new MapToObjectTransformer(targetClass);
    }

    public static MapToObjectTransformer fromMap(String beanName) {
        return new MapToObjectTransformer(beanName);
    }

    public static ObjectToJsonTransformer toJson() {
        return Transformers.toJson(null, null, null);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper) {
        return Transformers.toJson(jsonObjectMapper, null, null);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper, ObjectToJsonTransformer.ResultType resultType) {
        return Transformers.toJson(jsonObjectMapper, resultType, null);
    }

    public static ObjectToJsonTransformer toJson(String contentType) {
        return Transformers.toJson(null, null, contentType);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper, String contentType) {
        return Transformers.toJson(jsonObjectMapper, null, contentType);
    }

    public static ObjectToJsonTransformer toJson(ObjectToJsonTransformer.ResultType resultType, String contentType) {
        return Transformers.toJson(null, resultType, contentType);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper, ObjectToJsonTransformer.ResultType resultType, String contentType) {
        ObjectToJsonTransformer transformer = jsonObjectMapper != null ? (resultType != null ? new ObjectToJsonTransformer(jsonObjectMapper, resultType) : new ObjectToJsonTransformer(jsonObjectMapper)) : (resultType != null ? new ObjectToJsonTransformer(resultType) : new ObjectToJsonTransformer());
        if (contentType != null) {
            transformer.setContentType(contentType);
        }
        return transformer;
    }

    public static JsonToObjectTransformer fromJson() {
        return Transformers.fromJson(null, null);
    }

    public static JsonToObjectTransformer fromJson(Class<?> targetClass) {
        return Transformers.fromJson(targetClass, null);
    }

    public static JsonToObjectTransformer fromJson(JsonObjectMapper<?, ?> jsonObjectMapper) {
        return Transformers.fromJson(null, jsonObjectMapper);
    }

    public static JsonToObjectTransformer fromJson(Class<?> targetClass, JsonObjectMapper<?, ?> jsonObjectMapper) {
        return new JsonToObjectTransformer(targetClass, jsonObjectMapper);
    }

    public static PayloadSerializingTransformer serializer() {
        return Transformers.serializer(null);
    }

    public static PayloadSerializingTransformer serializer(Serializer<Object> serializer) {
        PayloadSerializingTransformer transformer = new PayloadSerializingTransformer();
        if (serializer != null) {
            transformer.setSerializer(serializer);
        }
        return transformer;
    }

    public static PayloadDeserializingTransformer deserializer(String ... whiteListPatterns) {
        return Transformers.deserializer(null, whiteListPatterns);
    }

    public static PayloadDeserializingTransformer deserializer(Deserializer<Object> deserializer, String ... whiteListPatterns) {
        PayloadDeserializingTransformer transformer = new PayloadDeserializingTransformer();
        transformer.setWhiteListPatterns(whiteListPatterns);
        if (deserializer != null) {
            transformer.setDeserializer(deserializer);
        }
        return transformer;
    }

    public static <T, U> PayloadTypeConvertingTransformer<T, U> converter(Converter<T, U> converter) {
        Assert.notNull(converter, (String)"The Converter<?, ?> is required for the PayloadTypeConvertingTransformer");
        PayloadTypeConvertingTransformer<T, U> transformer = new PayloadTypeConvertingTransformer<T, U>();
        transformer.setConverter(converter);
        return transformer;
    }

    public static SyslogToMapTransformer syslogToMap() {
        return new SyslogToMapTransformer();
    }

    public static <T> EncodingPayloadTransformer<T> encoding(Codec codec) {
        return new EncodingPayloadTransformer(codec);
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, Class<T> type) {
        return new DecodingTransformer<T>(codec, type);
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, String typeExpression) {
        return Transformers.decoding(codec, PARSER.parseExpression(typeExpression));
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, Function<Message<?>, Class<T>> typeFunction) {
        return Transformers.decoding(codec, new FunctionExpression(typeFunction));
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, Expression typeExpression) {
        return new DecodingTransformer(codec, typeExpression);
    }

    public static StreamTransformer fromStream() {
        return Transformers.fromStream(null);
    }

    public static StreamTransformer fromStream(String charset) {
        return new StreamTransformer(charset);
    }
}

