/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.context;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class IntegrationFlowRegistration {
    private IntegrationFlow integrationFlow;
    private IntegrationFlowContext integrationFlowContext;
    private String id;
    private MessageChannel inputChannel;
    private MessagingTemplate messagingTemplate;
    private ConfigurableListableBeanFactory beanFactory;

    IntegrationFlowRegistration(IntegrationFlow integrationFlow) {
        this.integrationFlow = integrationFlow;
    }

    void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    void setIntegrationFlowContext(IntegrationFlowContext integrationFlowContext) {
        this.integrationFlowContext = integrationFlowContext;
    }

    void setId(String id) {
        this.id = id;
    }

    void setIntegrationFlow(IntegrationFlow integrationFlow) {
        this.integrationFlow = integrationFlow;
    }

    public String getId() {
        return this.id;
    }

    public IntegrationFlow getIntegrationFlow() {
        return this.integrationFlow;
    }

    public MessageChannel getInputChannel() {
        if (this.inputChannel == null) {
            this.inputChannel = this.integrationFlow.getInputChannel();
            if (this.inputChannel == null) {
                throw new IllegalStateException("Only 'IntegrationFlow' instances started from the 'MessageChannel' (e.g. extracted from 'IntegrationFlow' Lambdas) can be used for direct 'send' operation. But [" + this.integrationFlow + "] ins't one of them.\nConsider 'BeanFactory.getBean()' usage for sending messages to the required 'MessageChannel'.");
            }
        }
        return this.inputChannel;
    }

    public MessagingTemplate getMessagingTemplate() {
        if (this.messagingTemplate == null) {
            this.messagingTemplate = new MessagingTemplate(this.getInputChannel()){

                public Message<?> receive() {
                    return this.receiveAndConvert(Message.class);
                }

                public <T> T receiveAndConvert(Class<T> targetClass) {
                    throw new UnsupportedOperationException("The 'receive()/receiveAndConvert()' isn't supported on the 'IntegrationFlow' input channel.");
                }
            };
            this.messagingTemplate.setBeanFactory((BeanFactory)this.beanFactory);
        }
        return this.messagingTemplate;
    }

    public void start() {
        if (!(this.integrationFlow instanceof Lifecycle)) {
            throw new IllegalStateException("For 'autoStartup' mode the 'IntegrationFlow' must be an instance of 'Lifecycle'.\nConsider to implement it for [" + this.integrationFlow + "]. Or start dependent components on their own.");
        }
        ((Lifecycle)this.integrationFlow).start();
    }

    public void stop() {
        if (this.integrationFlow instanceof Lifecycle) {
            ((Lifecycle)this.integrationFlow).stop();
        }
    }

    public void destroy() {
        this.integrationFlowContext.remove(this.id);
    }

    public String toString() {
        return "IntegrationFlowRegistration{integrationFlow=" + this.integrationFlow + ", id='" + this.id + '\'' + ", inputChannel=" + this.inputChannel + '}';
    }
}

