/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.support.MessagingExceptionWrapper;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.IntegrationResourceHolderSynchronization;
import org.springframework.integration.transaction.PassThroughTransactionSynchronizationFactory;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ErrorHandler;

public abstract class AbstractPollingEndpoint
extends AbstractEndpoint
implements BeanClassLoaderAware {
    private final Object initializationMonitor = new Object();
    private Executor taskExecutor = new SyncTaskExecutor();
    private boolean syncExecutor = true;
    private ErrorHandler errorHandler;
    private boolean errorHandlerIsDefault;
    private Trigger trigger = new PeriodicTrigger(10L);
    private List<Advice> adviceChain;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private long maxMessagesPerPoll = -1L;
    private TransactionSynchronizationFactory transactionSynchronizationFactory;
    private volatile ScheduledFuture<?> runningTask;
    private volatile Runnable poller;
    private volatile boolean initialized;

    public AbstractPollingEndpoint() {
        this.setPhase(0x3FFFFFFF);
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor != null ? taskExecutor : new SyncTaskExecutor();
        this.syncExecutor = this.taskExecutor instanceof SyncTaskExecutor || this.taskExecutor instanceof ErrorHandlingTaskExecutor && ((ErrorHandlingTaskExecutor)((Object)this.taskExecutor)).isSyncExecutor();
    }

    protected Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    protected boolean isSyncExecutor() {
        return this.syncExecutor;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger != null ? trigger : new PeriodicTrigger(10L);
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setMaxMessagesPerPoll(long maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setTransactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        this.transactionSynchronizationFactory = transactionSynchronizationFactory;
    }

    public MessageChannel getDefaultErrorChannel() {
        if (!this.errorHandlerIsDefault && this.errorHandler instanceof MessagePublishingErrorHandler) {
            return ((MessagePublishingErrorHandler)this.errorHandler).getDefaultErrorChannel();
        }
        return null;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    protected boolean isReceiveOnlyAdvice(Advice advice) {
        return false;
    }

    protected void applyReceiveOnlyAdviceChain(Collection<Advice> chain) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onInit() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            Assert.notNull((Object)this.trigger, (String)"Trigger is required");
            if (this.taskExecutor != null && !(this.taskExecutor instanceof ErrorHandlingTaskExecutor)) {
                if (this.errorHandler == null) {
                    Assert.notNull((Object)this.getBeanFactory(), (String)"BeanFactory is required");
                    this.errorHandler = new MessagePublishingErrorHandler(new BeanFactoryChannelResolver(this.getBeanFactory()));
                    this.errorHandlerIsDefault = true;
                }
                this.taskExecutor = new ErrorHandlingTaskExecutor(this.taskExecutor, this.errorHandler);
            }
            if (this.transactionSynchronizationFactory == null && this.adviceChain != null) {
                if (this.adviceChain.stream().anyMatch(TransactionInterceptor.class::isInstance)) {
                    this.transactionSynchronizationFactory = new PassThroughTransactionSynchronizationFactory();
                }
            }
            this.initialized = true;
        }
        try {
            super.onInit();
        }
        catch (Exception e) {
            throw new BeanInitializationException("Cannot initialize: " + this, (Throwable)e);
        }
    }

    private Runnable createPoller() throws Exception {
        List<Advice> receiveOnlyAdviceChain = null;
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            receiveOnlyAdviceChain = this.adviceChain.stream().filter(this::isReceiveOnlyAdvice).collect(Collectors.toList());
        }
        Callable pollingTask = this::doPoll;
        List<Advice> adviceChain = this.adviceChain;
        if (!CollectionUtils.isEmpty(adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory(pollingTask);
            if (!CollectionUtils.isEmpty(adviceChain)) {
                adviceChain.stream().filter(advice -> !this.isReceiveOnlyAdvice((Advice)advice)).forEach(arg_0 -> ((ProxyFactory)proxyFactory).addAdvice(arg_0));
            }
            pollingTask = (Callable)proxyFactory.getProxy(this.beanClassLoader);
        }
        if (!CollectionUtils.isEmpty(receiveOnlyAdviceChain)) {
            this.applyReceiveOnlyAdviceChain(receiveOnlyAdviceChain);
        }
        return new Poller(pollingTask);
    }

    @Override
    protected void doStart() {
        if (!this.initialized) {
            this.onInit();
        }
        Assert.state((this.getTaskScheduler() != null ? 1 : 0) != 0, (String)"unable to start polling, no taskScheduler available");
        try {
            this.poller = this.createPoller();
        }
        catch (Exception e) {
            this.initialized = false;
            throw new MessagingException("Failed to create Poller", (Throwable)e);
        }
        this.runningTask = this.getTaskScheduler().schedule(this.poller, this.trigger);
    }

    @Override
    protected void doStop() {
        if (this.runningTask != null) {
            this.runningTask.cancel(true);
        }
        this.runningTask = null;
    }

    private boolean doPoll() {
        boolean result;
        IntegrationResourceHolder holder = this.bindResourceHolderIfNecessary(this.getResourceKey(), this.getResourceToBind());
        Message<?> message = null;
        try {
            message = this.receiveMessage();
        }
        catch (Exception e) {
            if (Thread.interrupted()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Poll interrupted - during stop()? : " + e.getMessage()));
                }
                return false;
            }
            throw (RuntimeException)e;
        }
        if (message == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Received no Message during the poll, returning 'false'");
            }
            result = false;
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Poll resulted in Message: " + message));
            }
            if (holder != null) {
                holder.setMessage(message);
            }
            try {
                this.handleMessage(message);
            }
            catch (Exception e) {
                if (e instanceof MessagingException) {
                    throw new MessagingExceptionWrapper(message, (MessagingException)((Object)e));
                }
                throw new MessagingException(message, (Throwable)e);
            }
            result = true;
        }
        return result;
    }

    protected abstract Message<?> receiveMessage();

    protected abstract void handleMessage(Message<?> var1);

    protected Object getResourceToBind() {
        return null;
    }

    protected String getResourceKey() {
        return null;
    }

    private IntegrationResourceHolder bindResourceHolderIfNecessary(String key, Object resource) {
        if (this.transactionSynchronizationFactory != null && resource != null && TransactionSynchronizationManager.isActualTransactionActive()) {
            Object resourceHolder;
            TransactionSynchronization synchronization = this.transactionSynchronizationFactory.create(resource);
            if (synchronization != null) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
                if (synchronization instanceof IntegrationResourceHolderSynchronization) {
                    IntegrationResourceHolderSynchronization integrationSynchronization = (IntegrationResourceHolderSynchronization)synchronization;
                    integrationSynchronization.setShouldUnbindAtCompletion(false);
                    if (!TransactionSynchronizationManager.hasResource((Object)resource)) {
                        TransactionSynchronizationManager.bindResource((Object)resource, (Object)integrationSynchronization.getResourceHolder());
                    }
                }
            }
            if ((resourceHolder = TransactionSynchronizationManager.getResource((Object)resource)) instanceof IntegrationResourceHolder) {
                IntegrationResourceHolder integrationResourceHolder = (IntegrationResourceHolder)resourceHolder;
                if (key != null) {
                    integrationResourceHolder.addAttribute(key, resource);
                }
                return integrationResourceHolder;
            }
        }
        return null;
    }

    private final class Poller
    implements Runnable {
        private final Callable<Boolean> pollingTask;

        Poller(Callable<Boolean> pollingTask) {
            this.pollingTask = pollingTask;
        }

        @Override
        public void run() {
            AbstractPollingEndpoint.this.taskExecutor.execute(() -> {
                int count = 0;
                while (AbstractPollingEndpoint.this.initialized && (AbstractPollingEndpoint.this.maxMessagesPerPoll <= 0L || (long)count < AbstractPollingEndpoint.this.maxMessagesPerPoll)) {
                    try {
                        if (!this.pollingTask.call().booleanValue()) break;
                        ++count;
                    }
                    catch (Exception e) {
                        Object resource;
                        if (e instanceof MessagingException) {
                            throw (MessagingException)((Object)((Object)e));
                        }
                        Message<?> failedMessage = null;
                        if (AbstractPollingEndpoint.this.transactionSynchronizationFactory != null && (resource = TransactionSynchronizationManager.getResource((Object)AbstractPollingEndpoint.this.getResourceToBind())) instanceof IntegrationResourceHolder) {
                            failedMessage = ((IntegrationResourceHolder)resource).getMessage();
                        }
                        throw new MessagingException(failedMessage, (Throwable)e);
                    }
                    finally {
                        Object resource;
                        if (AbstractPollingEndpoint.this.transactionSynchronizationFactory == null || !TransactionSynchronizationManager.hasResource((Object)(resource = AbstractPollingEndpoint.this.getResourceToBind()))) continue;
                        TransactionSynchronizationManager.unbindResource((Object)resource);
                    }
                }
            });
        }
    }
}

